/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.internal.p2.director.Explanation;
import org.eclipse.equinox.internal.p2.director.OptimizationFunction;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.SteppedTimeoutLexicoHelper;
import org.sat4j.pb.tools.WeightedObject;
import org.sat4j.specs.ContradictionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserDefinedOptimizationFunction
extends OptimizationFunction {
    private Collection<IInstallableUnit> alreadyExistingRoots;
    private SteppedTimeoutLexicoHelper<Object, Explanation> dependencyHelper;
    private IQueryable<IInstallableUnit> picker;

    public UserDefinedOptimizationFunction(IQueryable<IInstallableUnit> lastState, List<Projector.AbstractVariable> abstractVariables, List<Projector.AbstractVariable> optionalVariables, IQueryable<IInstallableUnit> picker, IInstallableUnit selectionContext, Map<String, Map<Version, IInstallableUnit>> slice, DependencyHelper<Object, Explanation> dependencyHelper, Collection<IInstallableUnit> alreadyInstalledIUs) {
        super(lastState, abstractVariables, optionalVariables, picker, selectionContext, slice);
        this.picker = picker;
        this.slice = slice;
        this.dependencyHelper = (SteppedTimeoutLexicoHelper)dependencyHelper;
        this.alreadyExistingRoots = alreadyInstalledIUs;
    }

    @Override
    public List<WeightedObject<? extends Object>> createOptimizationFunction(IInstallableUnit metaIu, Collection<IInstallableUnit> newRoots) {
        ArrayList weightedObjects = new ArrayList();
        ArrayList<Object> objects = new ArrayList<Object>();
        BigInteger weight = BigInteger.valueOf(this.slice.size() + 1);
        String[] criteria = new String[]{"+new", "-notuptodate", "-changed", "-removed"};
        BigInteger currentWeight = weight.pow(criteria.length - 1);
        int i = 0;
        while (i < criteria.length) {
            if (criteria[i].endsWith("new")) {
                weightedObjects.clear();
                this.newRoots(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("removed")) {
                weightedObjects.clear();
                this.removedRoots(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("notuptodate")) {
                weightedObjects.clear();
                this.notuptodate(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            } else if (criteria[i].endsWith("changed")) {
                weightedObjects.clear();
                this.changedRoots(weightedObjects, criteria[i].startsWith("+") ? currentWeight.negate() : currentWeight, metaIu);
                currentWeight = currentWeight.divide(weight);
            }
            objects.clear();
            boolean maximizes = criteria[i].startsWith("+");
            Iterator it = weightedObjects.iterator();
            while (it.hasNext()) {
                Object thing = ((WeightedObject)it.next()).thing;
                if (maximizes) {
                    thing = this.dependencyHelper.not(thing);
                }
                objects.add(thing);
            }
            this.dependencyHelper.addCriterion(objects);
            ++i;
        }
        weightedObjects.clear();
        return null;
    }

    protected void changedRoots(List<WeightedObject<?>> weightedObjects, BigInteger weight, IInstallableUnit entryPointIU) {
        Collection requirements = entryPointIU.getRequirements();
        for (IRequirement req : requirements) {
            IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
            IQueryResult matches = this.picker.query(query, null);
            Object[] changed = new Object[matches.toUnmodifiableSet().size()];
            int i = 0;
            for (IInstallableUnit match : matches) {
                Object object = changed[i++] = this.isInstalledAsRoot(match) ? this.dependencyHelper.not((Object)match) : match;
            }
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable("CHANGED");
                this.dependencyHelper.or((Object)FakeExplanation.getInstance(), (Object)abs, changed);
                weightedObjects.add(WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void newRoots(List<WeightedObject<?>> weightedObjects, BigInteger weight, IInstallableUnit entryPointIU) {
        Collection requirements = entryPointIU.getRequirements();
        for (IRequirement req : requirements) {
            IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
            IQueryResult matches = this.picker.query(query, null);
            boolean oneInstalled = false;
            for (IInstallableUnit match : matches) {
                boolean bl = oneInstalled = oneInstalled || this.isInstalledAsRoot(match);
            }
            if (oneInstalled) continue;
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable("NEW");
                this.dependencyHelper.or((Object)FakeExplanation.getInstance(), (Object)abs, matches.toArray(IInstallableUnit.class));
                weightedObjects.add(WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void removedRoots(List<WeightedObject<?>> weightedObjects, BigInteger weight, IInstallableUnit entryPointIU) {
        Collection requirements = entryPointIU.getRequirements();
        for (IRequirement req : requirements) {
            IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
            IQueryResult matches = this.picker.query(query, null);
            boolean installed = false;
            Object[] literals = new Object[matches.toUnmodifiableSet().size()];
            int i = 0;
            for (IInstallableUnit match : matches) {
                installed = installed || this.isInstalledAsRoot(match);
                literals[i++] = this.dependencyHelper.not((Object)match);
            }
            if (!installed) continue;
            try {
                Projector.AbstractVariable abs = new Projector.AbstractVariable("REMOVED");
                this.dependencyHelper.and((Object)FakeExplanation.getInstance(), (Object)abs, literals);
                weightedObjects.add(WeightedObject.newWO((Object)abs, (BigInteger)weight));
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void notuptodate(List<WeightedObject<?>> weightedObjects, BigInteger weight, IInstallableUnit entryPointIU) {
        Collection requirements = entryPointIU.getRequirements();
        for (IRequirement req : requirements) {
            IQuery query = QueryUtil.createMatchQuery((IExpression)req.getMatches(), (Object[])new Object[0]);
            IQueryResult matches = this.picker.query(query, null);
            ArrayList toSort = new ArrayList(matches.toUnmodifiableSet());
            Collections.sort(toSort, Collections.reverseOrder());
            if (toSort.size() == 0) continue;
            Projector.AbstractVariable abs = new Projector.AbstractVariable();
            Object notlatest = this.dependencyHelper.not(toSort.get(0));
            try {
                this.dependencyHelper.implication(new Object[]{abs}).implies(notlatest).named((Object)FakeExplanation.getInstance());
                Object[] clause = new Object[toSort.size()];
                toSort.toArray(clause);
                clause[0] = this.dependencyHelper.not((Object)abs);
                this.dependencyHelper.clause((Object)FakeExplanation.getInstance(), clause);
                int i = 1;
                while (i < toSort.size()) {
                    this.dependencyHelper.implication(new Object[]{notlatest, toSort.get(i)}).implies((Object)abs).named((Object)FakeExplanation.getInstance());
                    ++i;
                }
            }
            catch (ContradictionException e) {
                e.printStackTrace();
            }
            weightedObjects.add(WeightedObject.newWO((Object)abs, (BigInteger)weight));
        }
    }

    private boolean isInstalledAsRoot(IInstallableUnit isInstalled) {
        for (IInstallableUnit installed : this.alreadyExistingRoots) {
            if (!isInstalled.equals((Object)installed)) continue;
            return true;
        }
        return false;
    }

    private static class FakeExplanation
    extends Explanation {
        private static Explanation singleton = new FakeExplanation();

        private FakeExplanation() {
        }

        public static Explanation getInstance() {
            return singleton;
        }

        protected int orderValue() {
            return 100;
        }

        public int shortAnswer() {
            return 0;
        }
    }
}

