/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.equinoxhttpservice.internal;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.manager.ApplicationRegistrationException;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.application.manager.MountConflictException;
import org.eclipse.gyrex.http.equinoxhttpservice.internal.HttpServiceAppProvider;
import org.eclipse.gyrex.server.Platform;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceAppComponent {
    private static final String ORG_OSGI_SERVICE_HTTP_PORT = "org.osgi.service.http.port";
    private static final String DEFAULT_APP_ID = "org.eclipse.gyrex.http.equinoxhttpservice".concat(".application");
    private static final SystemSetting<Boolean> registerHttpServiceApplication = SystemSetting.newBooleanSetting((String)"gyrex.http.equinoxhttpservice.registerApplication", (String)"Enables the registration of a default Equinox HTTP Service application. Default is true in development mode or in case system property 'org.osgi.service.http.port' is set and false otherwise").usingDefault((Object)(Platform.inDevelopmentMode() ? Boolean.TRUE : System.getProperty("org.osgi.service.http.port") != null)).create();
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceAppComponent.class);
    private volatile IRuntimeContextRegistry runtimeContextRegistry;
    private volatile IApplicationManager applicationManager;

    public void activate() {
        if (!registerHttpServiceApplication.isTrue()) {
            return;
        }
        IRuntimeContext context = this.getRuntimeContextRegistry().get((IPath)Path.ROOT);
        if (context == null) {
            LOG.warn("Unable to start default HttpService application; context {} not available", (Object)Path.ROOT.toString());
            return;
        }
        IApplicationManager manager = this.getApplicationManager();
        try {
            manager.register(DEFAULT_APP_ID, HttpServiceAppProvider.ID, context, null);
            try {
                manager.mount("http:/", DEFAULT_APP_ID);
                manager.mount("https:/", DEFAULT_APP_ID);
            }
            catch (MountConflictException e) {
                LOG.debug("HttpService application {} will not be mounted again. {} ", (Object)DEFAULT_APP_ID, (Object)e.getMessage());
                return;
            }
            catch (MalformedURLException e) {
                return;
            }
            manager.activate(DEFAULT_APP_ID);
        }
        catch (ApplicationRegistrationException e) {
            LOG.info("HttpService application with id {} already registered.", (Object)DEFAULT_APP_ID);
            return;
        }
    }

    public void deactivate() {
    }

    public IApplicationManager getApplicationManager() {
        IApplicationManager manager = this.applicationManager;
        if (manager == null) {
            throw new IllegalStateException("application manager not available");
        }
        return manager;
    }

    public IRuntimeContextRegistry getRuntimeContextRegistry() {
        IRuntimeContextRegistry registry = this.runtimeContextRegistry;
        if (registry == null) {
            throw new IllegalStateException("context registry not available");
        }
        return registry;
    }

    public void setApplicationManager(IApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setRuntimeContextRegistry(IRuntimeContextRegistry runtimeContextRegistry) {
        this.runtimeContextRegistry = runtimeContextRegistry;
    }
}

