/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.monitoring.metrics;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;

public abstract class MetricSet
extends BaseMetric {
    public static final String SERVICE_NAME = MetricSet.class.getName();
    private final List<BaseMetric> metrics;
    private final String description;
    private final Map<String, String> properties;

    protected MetricSet(String id, String description, BaseMetric ... metrics) {
        this(id, description, (Map<String, String>)null, metrics);
    }

    protected MetricSet(String id, String description, Map<String, String> properties, BaseMetric ... metrics) {
        super(id);
        if (metrics == null) {
            throw new IllegalArgumentException("metrics may not be null");
        }
        this.metrics = new ArrayList<BaseMetric>(metrics.length);
        BaseMetric[] baseMetricArray = metrics;
        int n = metrics.length;
        int n2 = 0;
        while (n2 < n) {
            BaseMetric metric = baseMetricArray[n2];
            this.metrics.add(metric);
            ++n2;
        }
        this.description = StringUtils.trimToEmpty((String)description);
        if (properties != null) {
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (IdHelper.isValidId((String)entry.getKey())) continue;
                throw new IllegalArgumentException(String.format("invalid property key: %s", entry.getKey()));
            }
            this.properties = Collections.unmodifiableMap(properties);
        } else {
            this.properties = Collections.emptyMap();
        }
    }

    @Override
    protected void doResetStats() {
        for (BaseMetric metric : this.metrics) {
            metric.resetStats();
        }
    }

    @Override
    final Object[] dumpMetrics() {
        return NO_METRICS;
    }

    public final String getDescription() {
        return this.description;
    }

    protected final <T extends BaseMetric> T getMetric(int position, Class<T> metricType) throws IndexOutOfBoundsException, IllegalArgumentException {
        BaseMetric metric = this.metrics.get(position);
        if (metric == null) {
            return null;
        }
        if (!metricType.isAssignableFrom(metric.getClass())) {
            throw new IllegalArgumentException(MessageFormat.format("metric at position {0} is not of type {1} but of type {2}", position, metricType.getName(), metric.getClass().getName()));
        }
        return (T)metric;
    }

    public final List<BaseMetric> getMetrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public final Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        StringBuilder toString = new StringBuilder();
        toString.append(this.getClass().getName()).append('(').append(this.getId()).append(')');
        toString.append(" [");
        Object[] metrics = this.metrics.toArray();
        int i = 0;
        while (i < metrics.length) {
            if (i > 0) {
                toString.append(", ");
            } else {
                toString.append(' ');
            }
            Object metric = metrics[i];
            if (metric != null) {
                toString.append(metric);
            }
            if (i == metrics.length - 1) {
                toString.append(' ');
            }
            ++i;
        }
        toString.append("]");
        return toString.toString();
    }
}

