/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.derby.tests;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.eclipse.gyrex.persistence.derby.tests.MockRepositoryType;
import org.eclipse.gyrex.persistence.jdbc.internal.SimpledPooledJdbcRepositoryImpl;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JdbcRepositoryTest {
    private MockRepositoryType mockRepositoryType;
    private final AtomicLong getConnectionDuration = new AtomicLong();
    private final AtomicLong getConnectionCount = new AtomicLong();
    private final AtomicLong closeConnectionDuration = new AtomicLong();
    private final AtomicLong closeConnectionCount = new AtomicLong();
    private final AtomicInteger activeConnectionConcurreny = new AtomicInteger();

    private void close(SimpledPooledJdbcRepositoryImpl repository) {
        try {
            repository.close();
        }
        catch (Exception e) {
            Assert.fail((String)("Repository did not close properly: " + e.getMessage()));
        }
        Assert.assertTrue((String)"repository not closed", (boolean)repository.isClosed());
    }

    private void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (Exception e) {
            Assert.fail((String)("error while closing connection: " + e.getMessage()));
        }
    }

    private Callable<Exception> createConnectionCloseTask(final Future<Connection> connectionFuture, final SimpledPooledJdbcRepositoryImpl repository) {
        return new Callable<Exception>(){

            @Override
            public Exception call() throws Exception {
                while (true) {
                    try {
                        JdbcRepositoryTest.this.updateConcurrency(repository);
                        Connection connection = (Connection)connectionFuture.get();
                        JdbcRepositoryTest.this.updateConcurrency(repository);
                        long start = System.currentTimeMillis();
                        JdbcRepositoryTest.this.closeConnection(connection);
                        long duration = System.currentTimeMillis() - start;
                        JdbcRepositoryTest.this.closeConnectionDuration.addAndGet(duration);
                        JdbcRepositoryTest.this.closeConnectionCount.incrementAndGet();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        continue;
                    }
                    catch (CancellationException e) {
                        return e;
                    }
                    catch (ExecutionException e) {
                        return e;
                    }
                    break;
                }
                return null;
            }
        };
    }

    private Callable<Connection> createGetConnectionTask(final SimpledPooledJdbcRepositoryImpl repository, final CountDownLatch startSignal) {
        return new Callable<Connection>(){

            @Override
            public Connection call() throws Exception {
                if (startSignal != null) {
                    try {
                        startSignal.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                long start = System.currentTimeMillis();
                Connection connection = JdbcRepositoryTest.this.getConnection(repository);
                long duration = System.currentTimeMillis() - start;
                JdbcRepositoryTest.this.getConnectionDuration.addAndGet(duration);
                JdbcRepositoryTest.this.getConnectionCount.incrementAndGet();
                JdbcRepositoryTest.this.updateConcurrency(repository);
                return connection;
            }
        };
    }

    private SimpledPooledJdbcRepositoryImpl createRepository() {
        Repository repository = this.mockRepositoryType.createRepositoryInstance("test", null);
        Assert.assertNotNull((String)"repository must not be null", (Object)repository);
        Assert.assertTrue((String)"repository is not a JdbcRepository", (boolean)(repository instanceof SimpledPooledJdbcRepositoryImpl));
        return (SimpledPooledJdbcRepositoryImpl)repository;
    }

    private Connection getConnection(SimpledPooledJdbcRepositoryImpl repository) throws SQLException {
        Connection connection = repository.getConnection();
        Assert.assertNotNull((String)"no connection returned", (Object)connection);
        return connection;
    }

    @Before
    public void setUp() throws Exception {
        this.mockRepositoryType = new MockRepositoryType();
    }

    @After
    public void tearDown() throws Exception {
        this.mockRepositoryType = null;
    }

    @Test
    public void testCloseRepository() throws Exception {
        SimpledPooledJdbcRepositoryImpl repository = this.createRepository();
        this.close(repository);
    }

    @Test
    public void testCreateRepository() throws Exception {
        SimpledPooledJdbcRepositoryImpl repository = this.createRepository();
        try {
            repository.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testGetConnectionFromRepository() throws Exception {
        SimpledPooledJdbcRepositoryImpl repository = this.createRepository();
        Connection connection = this.getConnection(repository);
        Assert.assertEquals((String)"active connections count is not correct", (int)1, (int)repository.getActiveConnectionsCount());
        this.closeConnection(connection);
        Assert.assertEquals((String)"active connections count is not correct", (int)0, (int)repository.getActiveConnectionsCount());
        this.close(repository);
    }

    @Test
    public void testGetConnectionFromRepositoryMany() throws Exception {
        SimpledPooledJdbcRepositoryImpl repository = this.createRepository();
        Connection conn1 = this.getConnection(repository);
        Assert.assertEquals((String)"active connections count is not correct", (int)1, (int)repository.getActiveConnectionsCount());
        Connection conn2 = this.getConnection(repository);
        Assert.assertEquals((String)"active connections count is not correct", (int)2, (int)repository.getActiveConnectionsCount());
        Connection conn3 = this.getConnection(repository);
        Assert.assertEquals((String)"active connections count is not correct", (int)3, (int)repository.getActiveConnectionsCount());
        Connection conn4 = this.getConnection(repository);
        Assert.assertEquals((String)"active connections count is not correct", (int)4, (int)repository.getActiveConnectionsCount());
        this.closeConnection(conn4);
        Assert.assertEquals((String)"active connections count is not correct", (int)3, (int)repository.getActiveConnectionsCount());
        this.closeConnection(conn1);
        Assert.assertEquals((String)"active connections count is not correct", (int)2, (int)repository.getActiveConnectionsCount());
        this.closeConnection(conn3);
        Assert.assertEquals((String)"active connections count is not correct", (int)1, (int)repository.getActiveConnectionsCount());
        this.closeConnection(conn2);
        Assert.assertEquals((String)"active connections count is not correct", (int)0, (int)repository.getActiveConnectionsCount());
        this.close(repository);
    }

    private void testGetConnectionFromRepositoryParallel(int maxConcurrency, int taskToSchedule, int poolCapacity) {
        SimpledPooledJdbcRepositoryImpl repository = this.createRepository();
        repository.setPoolCapacity(poolCapacity);
        CountDownLatch startSignal = new CountDownLatch(1);
        ExecutorService pool = maxConcurrency > 0 ? Executors.newFixedThreadPool(maxConcurrency) : Executors.newCachedThreadPool();
        ArrayList<Future<Exception>> results = new ArrayList<Future<Exception>>(taskToSchedule);
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < taskToSchedule) {
            Future<Connection> connectionFuture = pool.submit(this.createGetConnectionTask(repository, startSignal));
            results.add(pool.submit(this.createConnectionCloseTask(connectionFuture, repository)));
            ++i;
        }
        long duration = System.currentTimeMillis() - start;
        String SYSOUTPREFIX = "[testGetConnectionFromRepositoryParallel " + maxConcurrency + "/" + taskToSchedule + "/" + poolCapacity + "] ";
        System.out.println(String.valueOf(SYSOUTPREFIX) + taskToSchedule + " tasks submitted in: " + duration + "ms");
        startSignal.countDown();
        start = System.currentTimeMillis();
        pool.shutdown();
        while (!pool.isTerminated()) {
            try {
                pool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        duration = System.currentTimeMillis() - start;
        System.out.println(String.valueOf(SYSOUTPREFIX) + "pool shutdown in: " + duration + "ms");
        block8: for (Future future : results) {
            while (true) {
                try {
                    Exception e = (Exception)future.get();
                    if (e == null) continue block8;
                    e.printStackTrace();
                    Assert.fail((String)("Error while retrieving connection: " + e.getMessage()));
                    continue block8;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (CancellationException e) {
                    continue block8;
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    Assert.fail((String)("Error while closing connection: " + e.getMessage()));
                }
                break;
            }
        }
        Assert.assertEquals((String)"active connections count is not correct", (int)0, (int)repository.getActiveConnectionsCount());
        System.out.println(String.valueOf(SYSOUTPREFIX) + "max active connections: " + this.activeConnectionConcurreny.get());
        System.out.println(String.valueOf(SYSOUTPREFIX) + "average getConnection time: " + Math.round(this.getConnectionDuration.doubleValue() / this.getConnectionCount.doubleValue()) + "ms");
        System.out.println(String.valueOf(SYSOUTPREFIX) + "average closeConnection time: " + Math.round(this.closeConnectionDuration.doubleValue() / this.closeConnectionCount.doubleValue()) + "ms");
        System.out.print(String.valueOf(SYSOUTPREFIX) + repository.getJdbcRepositoryMetrics());
        this.close(repository);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_01() throws Exception {
        this.testGetConnectionFromRepositoryParallel(0, 100, 0);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_02() throws Exception {
        this.testGetConnectionFromRepositoryParallel(0, 1000, 0);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_03() throws Exception {
        this.testGetConnectionFromRepositoryParallel(100, 1000, 0);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_04() throws Exception {
        this.testGetConnectionFromRepositoryParallel(1000, 1000, 0);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_05() throws Exception {
        this.testGetConnectionFromRepositoryParallel(1000, 2000, 0);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_06a() throws Exception {
        this.testGetConnectionFromRepositoryParallel(1000, 10000, 0);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_06b() throws Exception {
        this.testGetConnectionFromRepositoryParallel(1000, 10000, 10);
    }

    @Test
    public void testGetConnectionFromRepositoryParallel_06c() throws Exception {
        this.testGetConnectionFromRepositoryParallel(1000, 10000, 100);
    }

    private int updateConcurrency(SimpledPooledJdbcRepositoryImpl repository) {
        int activeConnectionsCount = repository.getActiveConnectionsCount();
        int activeConnectionConcurrenyCurrent = this.activeConnectionConcurreny.get();
        if (activeConnectionConcurrenyCurrent < activeConnectionsCount) {
            this.activeConnectionConcurreny.compareAndSet(activeConnectionConcurrenyCurrent, activeConnectionsCount);
        }
        return activeConnectionsCount;
    }
}

