/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.console;

import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.internal.storage.RepositoryRegistry;
import org.kohsuke.args4j.Option;

public abstract class BaseRepoSelectingCommand
extends Command {
    @Option(name="-r", aliases={"--repositoryIdFilter"}, metaVar="ID-SUB-STRING", usage="repository sub-string id filter")
    protected String repositoryIdFilter;
    private RepositoryRegistry repositoryRegistry;

    public BaseRepoSelectingCommand(String description) {
        super(description);
    }

    protected void doExecute() throws Exception {
        RepositoryRegistry registry = this.getRegistry();
        String filter = this.getRepositoryIdFilter();
        TreeSet<String> filteredRepoIds = new TreeSet<String>();
        Collection<String> repositoryIds = registry.getRepositoryIds();
        for (String repoId : repositoryIds) {
            if (filter != null && !StringUtils.contains((String)repoId, (String)filter)) continue;
            filteredRepoIds.add(repoId);
        }
        if (filteredRepoIds.isEmpty()) {
            this.printf("No repositories found!", new Object[0]);
            return;
        }
        for (String repoId : filteredRepoIds) {
            this.processRepository(repoId);
        }
    }

    protected RepositoryRegistry getRegistry() {
        if (this.repositoryRegistry != null) {
            return this.repositoryRegistry;
        }
        this.repositoryRegistry = PersistenceActivator.getInstance().getRepositoriesManager();
        return this.repositoryRegistry;
    }

    protected String getRepositoryIdFilter() {
        return this.repositoryIdFilter;
    }

    protected abstract void processRepository(String var1) throws Exception;
}

