/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.lang.annotation.Annotation;
import java.util.Collection;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.provider.di.ExtendedObjectResolver;
import org.eclipse.gyrex.persistence.PersistenceUtil;
import org.eclipse.gyrex.persistence.internal.PersistenceActivator;
import org.eclipse.gyrex.persistence.storage.Repository;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.gyrex.persistence.storage.di.RequiredContentType;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryObjectResolverByContentTypeComponent
extends ExtendedObjectResolver {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryObjectResolverByContentTypeComponent.class);

    public Object get(Class<?> type, IRuntimeContext context, Annotation annotation) {
        RepositoryContentType contentType = this.getContentType(annotation);
        if (contentType == null) {
            LOG.error("No content type found for annotation ({}). Injection might fail!", (Object)annotation);
            return null;
        }
        Repository repository = null;
        try {
            repository = PersistenceUtil.getRepository(context, contentType);
        }
        catch (IllegalStateException e) {
            LOG.error("{} Injection might fail!", (Object)e.getMessage());
            return null;
        }
        try {
            return type.cast(repository);
        }
        catch (ClassCastException e) {
            LOG.error("Repository ({}) discovered for injection based on annotation ({}) does not match the expected type. {}", new Object[]{repository, annotation, e.getMessage()});
            return null;
        }
    }

    private RepositoryContentType getContentType(Annotation annotation) {
        Collection<RepositoryContentType> contentTypes = PersistenceActivator.getInstance().getContentTypeTracker().getContentTypes(((RequiredContentType)annotation).value());
        if (contentTypes.isEmpty()) {
            return null;
        }
        VersionRange versionRange = new VersionRange(((RequiredContentType)annotation).version());
        for (RepositoryContentType contentType : contentTypes) {
            if (!versionRange.includes(new Version(contentType.getVersion()))) continue;
            return contentType;
        }
        return null;
    }
}

