/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.jetty.internal;

import java.util.Collection;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.CertificatesContentProvider;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.ImportCertificateDialog;
import org.eclipse.gyrex.admin.ui.http.jetty.internal.JettyConfigActivator;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.http.jetty.admin.ChannelDescriptor;
import org.eclipse.gyrex.http.jetty.admin.ICertificate;
import org.eclipse.gyrex.http.jetty.admin.IJettyManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class CertificatesArea {
    private ISelectionChangedListener updateButtonsListener;
    private Button addButton;
    private Button removeButton;
    private ListViewer certificatesList;
    private Composite pageComposite;

    public void activate() {
        if (this.certificatesList != null) {
            this.certificatesList.setInput((Object)this.getJettyManager());
            this.updateButtonsListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CertificatesArea.this.updateButtons();
                }
            };
            this.certificatesList.addSelectionChangedListener(this.updateButtonsListener);
        }
    }

    void addButtonPressed() {
        ImportCertificateDialog dialog = new ImportCertificateDialog(SwtUtil.getShell((Widget)this.addButton), this.getJettyManager());
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    CertificatesArea.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    public void createChannelsControls(Composite parent) {
        this.pageComposite = parent;
        Infobox infobox = new Infobox(this.pageComposite);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Certificates");
        infobox.addParagraph("In this section you can define SSL Certificates, which can be assigned to Jetty channels to support SSL encryption.");
        Composite description = new Composite(this.pageComposite, 0);
        GridData gd = AdminUiUtil.createFillData();
        gd.verticalIndent = 10;
        description.setLayoutData((Object)gd);
        description.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin((int)2, (boolean)false));
        this.certificatesList = new ListViewer(description, 2052);
        List list = this.certificatesList.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.certificatesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.certificatesList.setLabelProvider((IBaseLabelProvider)new CertificatesLabelProvider());
        this.certificatesList.setContentProvider((IContentProvider)new CertificatesContentProvider());
        Composite buttons = new Composite(description, 0);
        buttons.setLayoutData((Object)new GridData(4, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.addButton = this.createButton(buttons, "Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                CertificatesArea.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttons, "Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                CertificatesArea.this.removeButtonPressed();
            }
        });
    }

    public void deactivate() {
        if (this.certificatesList != null) {
            if (this.updateButtonsListener != null) {
                this.certificatesList.removeSelectionChangedListener(this.updateButtonsListener);
                this.updateButtonsListener = null;
            }
            if (!this.certificatesList.getList().isDisposed()) {
                this.certificatesList.setInput(null);
            }
        }
    }

    private IJettyManager getJettyManager() {
        return JettyConfigActivator.getInstance().getJettyManager();
    }

    private ICertificate getSelectedCertificate() {
        IStructuredSelection selection = (IStructuredSelection)this.certificatesList.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ICertificate) {
            return (ICertificate)selection.getFirstElement();
        }
        return null;
    }

    public void refresh() {
        this.certificatesList.refresh();
        this.updateButtons();
    }

    void removeButtonPressed() {
        final ICertificate certificate = this.getSelectedCertificate();
        if (certificate == null) {
            return;
        }
        String certificateId = certificate.getId();
        IJettyManager jettyManager = this.getJettyManager();
        Collection channels = jettyManager.getChannelsUsingCertificate(certificateId);
        if (!channels.isEmpty()) {
            StrBuilder errorMessage = new StrBuilder();
            errorMessage.appendln("Certificate is still in use and cannot be removed.");
            errorMessage.appendln("");
            errorMessage.appendln("Used by:");
            for (ChannelDescriptor channelDescriptor : channels) {
                errorMessage.append("  * ").appendln(channelDescriptor.getId());
            }
            NonBlockingMessageDialogs.openError((Shell)SwtUtil.getShell((Widget)this.pageComposite), (String)"Still In Use", (String)errorMessage.toString(), (DialogCallback)new DialogCallback(){
                private static final long serialVersionUID = 1L;

                public void dialogClosed(int returnCode) {
                    if (returnCode != 0) {
                        return;
                    }
                }
            });
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.pageComposite), (String)"Remove selected Certificate", (String)String.format("Do you really want to delete certificate %s?", certificate.getId()), (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                CertificatesArea.this.getJettyManager().removeCertificate(certificate.getId());
                CertificatesArea.this.refresh();
            }
        });
    }

    void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.certificatesList.getSelection()).size();
        if (selectedElementsCount == 0) {
            this.addButton.setEnabled(true);
            this.removeButton.setEnabled(false);
            return;
        }
        this.addButton.setEnabled(selectedElementsCount == 1);
        this.removeButton.setEnabled(selectedElementsCount == 1);
    }

    static class CertificatesLabelProvider
    extends LabelProvider {
        private static final long serialVersionUID = 1L;

        CertificatesLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ICertificate) {
                ICertificate cert = (ICertificate)element;
                return String.format("%s (%s)", cert.getId(), cert.getInfo());
            }
            return super.getText(element);
        }
    }
}

