/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.worker;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.gyrex.cloud.services.queue.IMessage;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.IJobContext;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.worker.JobContext;
import org.eclipse.gyrex.jobs.internal.worker.JobInfo;
import org.eclipse.gyrex.jobs.internal.worker.JobLogHelper;
import org.eclipse.gyrex.jobs.internal.worker.JobStateSynchronizer;
import org.eclipse.gyrex.jobs.internal.worker.TriggerScheduleEntriesWhenDone;
import org.eclipse.gyrex.jobs.internal.worker.WorkerEngineMetrics;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerEngine
extends Job {
    private static final int DEFAULT_IDLE_SLEEP_TIME = 20000;
    private static final int DEFAULT_NON_IDLE_SLEEP_TIME = 3000;
    private static final long MAX_ERROR_SLEEP_TIME = 30000L;
    private static final SystemSetting<Integer> idleSleepTimeMsSetting = SystemSetting.newIntegerSetting((String)"gyrex.jobs.workerEngine.idleSleepTimeMs", (String)"Maximum sleep time in milli-seconds of the worker engine when there are no jobs waiting in the queue.").usingDefault((Object)20000).create();
    private static final SystemSetting<Integer> nonIdleSleepTimeMsSetting = SystemSetting.newIntegerSetting((String)"gyrex.jobs.workerEngine.nonIdleSleepTimeMs", (String)"Maximum sleep time in milli-seconds of the worker engine when there are jobs waiting in the queue.").usingDefault((Object)3000).create();
    private static final SystemSetting<Integer> maxConcurrentScheduledJobsSetting = SystemSetting.newIntegerSetting((String)"gyrex.jobs.workerEngine.maxConcurrentScheduledJobs", (String)"The maximum number of jobs that will allowed to run in parallel on the local instance. Default is the number of available processors as detected by the Java VM.").usingDefault((Object)Runtime.getRuntime().availableProcessors()).create();
    private static final SystemSetting<Boolean> skipPriorityQueueSetting = SystemSetting.newBooleanSetting((String)"gyrex.jobs.workerEngine.doNotCheckPriorityQueue", (String)"If set to true, the priority queue will not be checked by this worker engine instance.").usingDefault((Object)Boolean.FALSE).create();
    private static final SystemSetting<String> queueIdSetting = SystemSetting.newStringSetting((String)"gyrex.jobs.workerEngine.queueId", (String)"The id of the queue to check for jobs. Default is the job system's default queue as spec'd by IJobManager.DEFAULT_QUEUE.").usingDefault((Object)"gyrex.jobs.queue.default").create();
    private static final String NODE_WORKER_ENGINE = "workerEngine";
    private static final String PREF_KEY_SUSPENDED = "suspended";
    private static final Logger LOG = LoggerFactory.getLogger(WorkerEngine.class);
    private final WorkerEngineMetrics metrics;
    private final int maxConcurrentJobs;
    private final int idleSleepTime;
    private final int nonIdleSleepTime;
    private final String queueId;
    private final boolean skipPriorityQueue;
    private long engineSleepTime = 20000L;
    private final AtomicInteger scheduledJobsCount = new AtomicInteger();
    private final IJobChangeListener jobFinishedListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent event) {
            WorkerEngine.this.scheduledJobsCount.decrementAndGet();
            WorkerEngine.this.metrics.getCapacity().channelFinished();
        }

        public void scheduled(IJobChangeEvent event) {
            WorkerEngine.this.metrics.getCapacity().channelStarted(0L);
        }
    };

    private static Preferences getWorkerEnginePreferences() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_WORKER_ENGINE);
    }

    public static boolean isSuspended() {
        return WorkerEngine.getWorkerEnginePreferences().getBoolean(PREF_KEY_SUSPENDED, false);
    }

    public static void resume() throws BackingStoreException {
        Preferences preferences = WorkerEngine.getWorkerEnginePreferences();
        preferences.remove(PREF_KEY_SUSPENDED);
        preferences.flush();
    }

    public static void suspend() throws BackingStoreException {
        Preferences preferences = WorkerEngine.getWorkerEnginePreferences();
        preferences.putBoolean(PREF_KEY_SUSPENDED, true);
        preferences.flush();
    }

    public WorkerEngine(WorkerEngineMetrics metrics) {
        super("Gyrex Worker Engine Job");
        this.metrics = metrics;
        this.setSystem(true);
        this.setPriority(30);
        this.idleSleepTime = (Integer)idleSleepTimeMsSetting.get();
        this.nonIdleSleepTime = (Integer)nonIdleSleepTimeMsSetting.get();
        this.maxConcurrentJobs = (Integer)maxConcurrentScheduledJobsSetting.get();
        this.queueId = (String)queueIdSetting.get();
        this.skipPriorityQueue = skipPriorityQueueSetting.isTrue();
    }

    private void abortJob(JobStateSynchronizer stateSynchronizer, IQueue queue, IMessage message) {
        try {
            queue.deleteMessage(message);
        }
        catch (NoSuchElementException e) {
            stateSynchronizer.setJobInactive();
        }
        stateSynchronizer.setJobAborted();
    }

    private void addTriggerForDependentJobs(Job job, JobInfo info, JobContext jobContext) {
        String[] scheduleInfo = StringUtils.split((String)info.getScheduleInfo(), (char)',');
        if (scheduleInfo != null && scheduleInfo.length > 2) {
            job.addJobChangeListener((IJobChangeListener)new TriggerScheduleEntriesWhenDone(scheduleInfo, jobContext));
        }
    }

    private JobContext createContext(JobInfo info) {
        IRuntimeContextRegistry contextRegistry = (IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class);
        IRuntimeContext context = contextRegistry.get(info.getContextPath());
        if (context == null) {
            throw new IllegalStateException(String.format("Context %s not available!", info.getContextPath().toString()));
        }
        return new JobContext(context, info);
    }

    private Job createJob(IQueue queue, IMessage message, JobInfo info, JobContext jobContext) {
        try {
            JobLogHelper.setupMdc(jobContext);
            Job job = this.createJobInstance(info, jobContext);
            return job;
        }
        catch (LinkageError e) {
            this.handleCreateJobError(queue, message, info, jobContext, e);
            return null;
        }
        catch (Exception e) {
            this.handleCreateJobError(queue, message, info, jobContext, e);
            return null;
        }
        finally {
            JobLogHelper.clearMdc();
        }
    }

    private Job createJobInstance(JobInfo info, IJobContext jobContext) throws Exception {
        JobProvider provider = JobsActivator.getInstance().getJobProviderRegistry().getProvider(info.getJobTypeId());
        if (provider == null) {
            throw new IllegalStateException(String.format("Job type %s not available!", info.getJobTypeId()));
        }
        Job job = provider.createJob(info.getJobTypeId(), jobContext);
        if (job == null) {
            throw new IllegalStateException(String.format("Provider %s did not create job of type %s!", provider.toString(), info.getJobTypeId()));
        }
        return job;
    }

    private void discardJobMessage(IQueue queue, IMessage message) {
        try {
            if (!queue.deleteMessage(message)) {
                LOG.warn("Unable to remove job message {}. Job might be processed again.", (Object)message);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (Exception e) {
            LOG.error("Error removing job message {}: {}", new Object[]{message, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        }
    }

    private IQueue getQueue(String queueId) {
        return JobsActivator.getInstance().getQueueService().getQueue(queueId, null);
    }

    protected long getReceiveTimeout() {
        return TimeUnit.MINUTES.toMillis(1L);
    }

    private void handleCreateJobError(IQueue queue, IMessage message, JobInfo info, JobContext jobContext, Throwable e) {
        LOG.error("Error creating job ({}): {}", new Object[]{message, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
        this.discardJobMessage(queue, message);
        try {
            long timestamp = System.currentTimeMillis();
            JobManagerImpl jobManager = (JobManagerImpl)jobContext.getContext().get(IJobManager.class);
            jobManager.setResult(info.getJobId(), jobContext.getParameter(), (IStatus)new Status(4, "org.eclipse.gyrex.jobs", String.format("Error creating job: %s", e.getMessage()), e), timestamp, timestamp, info.getQueueTrigger(), info.getQueueTimestamp());
        }
        catch (Exception jobManagerException) {
            LOG.error("Error updating job result for job ({}): {}", new Object[]{info.getJobId(), ExceptionUtils.getRootCauseMessage((Throwable)jobManagerException)});
        }
    }

    private JobInfo parseJobInfo(IQueue queue, IMessage message) {
        try {
            return JobInfo.parse(message);
        }
        catch (IOException e) {
            LOG.error("Invalid job info in message {}: {}", new Object[]{message, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            this.discardJobMessage(queue, message);
            return null;
        }
    }

    private boolean processNextJobFromAnyQueue() {
        if (this.scheduledJobsCount.get() > this.maxConcurrentJobs) {
            if (JobsDebug.workerEngine) {
                LOG.debug("There are currently {} jobs scheduled. Won't schedule more at this time.", (Object)this.scheduledJobsCount);
            }
            this.metrics.getCapacity().channelDenied();
            this.metrics.setStatus("EXHAUSTED", "capacity limit reached");
            return false;
        }
        IQueue queue = this.getQueue("gyrex.jobs.queue.priority");
        if (queue != null && !this.skipPriorityQueue) {
            if (JobsDebug.workerEngine) {
                LOG.debug("Checking priority queue.");
            }
            if (this.processNextJobFromQueue(queue)) {
                return true;
            }
        }
        if ((queue = this.getQueue(this.queueId)) == null) {
            if (JobsDebug.workerEngine) {
                LOG.debug("Queue {} does not exists. Nothing to work one.", (Object)this.queueId);
            }
            return false;
        }
        return this.processNextJobFromQueue(queue);
    }

    private boolean processNextJobFromQueue(IQueue queue) {
        this.metrics.setStatus("PROCESSING", "processing next job from queue");
        HashMap<String, Long> requestProperties = new HashMap<String, Long>(1);
        requestProperties.put("queue.message.receive.timeout", this.getReceiveTimeout());
        List messages = queue.receiveMessages(1, requestProperties);
        if (messages.isEmpty()) {
            return false;
        }
        IMessage message = (IMessage)messages.get(0);
        JobInfo info = this.parseJobInfo(queue, message);
        if (info == null) {
            return true;
        }
        JobContext jobContext = this.createContext(info);
        Job job = this.createJob(queue, message, info, jobContext);
        if (job == null) {
            return true;
        }
        JobStateSynchronizer stateSynchronizer = new JobStateSynchronizer(job, jobContext, info);
        if (stateSynchronizer.isJobMarkedAborting()) {
            this.abortJob(stateSynchronizer, queue, message);
        } else {
            this.scheduleJob(job, info, jobContext, stateSynchronizer, queue, message);
        }
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (WorkerEngine.isSuspended()) {
                if (JobsDebug.workerEngine) {
                    LOG.debug("Worker engine is suspended.");
                }
                this.metrics.setStatus("SUSPENDED", "suspended in preferences");
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            this.metrics.getCapacity().setChannelsCapacity((long)this.maxConcurrentJobs);
            boolean moreJobsAvailable = this.processNextJobFromAnyQueue();
            this.engineSleepTime = RandomUtils.nextInt((int)(moreJobsAvailable ? this.nonIdleSleepTime : this.idleSleepTime));
            if (!monitor.isCanceled()) {
                this.metrics.setStatus("SLEEPING", "expected sleep time: " + this.engineSleepTime);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            this.metrics.setStatus("CANCELED", "monitor is canceled");
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (Exception e) {
            this.engineSleepTime = Math.min(this.engineSleepTime * 2L, 30000L);
            LOG.error("Unable to process queued jobs. Please verify the system is setup properly. {}", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            this.metrics.setStatus("ERROR", ExceptionUtils.getRootCauseMessage((Throwable)e));
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        finally {
            if (!monitor.isCanceled()) {
                if (JobsDebug.workerEngine) {
                    LOG.debug("Rescheduling worker engine to run again in {} seconds", (Object)TimeUnit.MILLISECONDS.toSeconds(this.engineSleepTime));
                }
                this.schedule(this.engineSleepTime);
            }
        }
    }

    private void scheduleJob(Job job, JobInfo info, JobContext jobContext, JobStateSynchronizer stateSynchronizer, IQueue queue, IMessage message) {
        if (!stateSynchronizer.setJobActive()) {
            return;
        }
        try {
            if (!queue.deleteMessage(message)) {
                stateSynchronizer.setJobInactive();
                return;
            }
        }
        catch (NoSuchElementException e) {
            stateSynchronizer.setJobInactive();
            return;
        }
        if (JobsDebug.workerEngine) {
            LOG.debug("Scheduling job {} from queue {}", (Object)info.getJobId(), (Object)queue.getId());
        }
        job.addJobChangeListener((IJobChangeListener)stateSynchronizer);
        job.addJobChangeListener(this.jobFinishedListener);
        this.addTriggerForDependentJobs(job, info, jobContext);
        job.schedule();
        this.scheduledJobsCount.incrementAndGet();
    }
}

