/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.context.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class EditContextPrefsDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private static final int COL_NAME = 0;
    private static final int COL_VALUE = 1;
    private final StringDialogField nameField = new StringDialogField();
    private final StringDialogField valueField = new StringDialogField();
    private final StringDialogField qualifierField = new StringDialogField();
    private final IRuntimeContextDefinitionManager registryImpl = null;
    private List<KeyValuePair> prefSettings;
    private List<Preferences> prefQualifiers;
    private TableViewer viewer;
    private TableViewerColumn nameColumn;
    private TableViewerColumn valueColumn;
    private final Preferences prefRootNode;
    private Preferences currentPrefNode;
    private Button addOrUpdateButton;
    private Button deleteButton;
    private Button addQualifierButton;
    private Combo qualifierCombo;
    private Label label;

    private static void sort(TableViewer viewer, int property, boolean ascending) {
        if ((viewer.getControl().getStyle() & 0x10000000) != 0) {
            List input = (List)viewer.getInput();
            Collections.sort(input, new KeyValuePairComparator(property, ascending));
            viewer.refresh();
        } else {
            viewer.setComparator((ViewerComparator)new KeyValuePairComparator(property, ascending));
        }
    }

    private static int updateSortDirection(TableColumn column) {
        Table table = column.getParent();
        if (column == table.getSortColumn()) {
            if (table.getSortDirection() == 128) {
                table.setSortDirection(1024);
            } else {
                table.setSortDirection(128);
            }
        } else {
            table.setSortColumn(column);
            table.setSortDirection(1024);
        }
        return table.getSortDirection();
    }

    public EditContextPrefsDialog(Shell parent, Preferences prefNode) {
        super(parent);
        this.prefRootNode = prefNode;
        this.currentPrefNode = prefNode;
        this.prefSettings = new ArrayList<KeyValuePair>();
        this.prefQualifiers = new ArrayList<Preferences>();
        this.initContent();
        this.setTitle("View and Edit Context Preferences");
        this.setShellStyle(67696);
    }

    protected void addOrUpdateButtonPressed() {
        String qualifier = this.qualifierField.getText();
        this.currentPrefNode = StringUtils.isEmpty((String)qualifier) ? this.prefRootNode : this.prefRootNode.node(qualifier);
        String name = this.nameField.getText();
        String value = this.valueField.getText();
        if (StringUtils.isEmpty((String)name)) {
            return;
        }
        if (StringUtils.isEmpty((String)value)) {
            value = "";
        }
        this.currentPrefNode.put(name, value);
        try {
            this.currentPrefNode.flush();
            this.fillQualifierCombo();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new UnhandledException((Throwable)e);
        }
        this.changePreferencesQualifier(qualifier);
        this.nameField.setText("");
        this.valueField.setText("");
    }

    protected void changePreferencesQualifier(String text) {
        if (StringUtils.isEmpty((String)text)) {
            text = ".settings";
        }
        this.qualifierCombo.setText(text);
        try {
            Preferences node = null;
            if (text.equals(".settings")) {
                node = this.prefRootNode;
                this.qualifierField.setText("");
            } else {
                node = this.prefRootNode.node(text);
                this.qualifierField.setText(text);
            }
            if (node != null) {
                String[] settingNames;
                this.currentPrefNode = node;
                this.prefSettings = new ArrayList<KeyValuePair>();
                String[] stringArray = settingNames = node.keys();
                int n = settingNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String settingName = stringArray[n2];
                    KeyValuePair pair = new KeyValuePair(settingName, node.get(settingName, null));
                    this.prefSettings.add(pair);
                    ++n2;
                }
                this.viewer.setInput(this.prefSettings);
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new UnhandledException((Throwable)e);
        }
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        gd.widthHint = this.convertHorizontalDLUsToPixels(400);
        gd.heightHint = this.convertHorizontalDLUsToPixels(250);
        this.qualifierField.setLabelText("Preference Qualifier/Group");
        this.nameField.setLabelText("Preference Name");
        this.valueField.setLabelText("Preference Value");
        Text warning = new Text(composite, 72);
        warning.setText("All preference settings in the context " + this.prefRootNode.absolutePath() + " are listed below. You can add new preferences or delete or edit existing ones. Please note, that Preferences in a Gyrex Context can be grouped by qualifiers. You can select the qualifier/group in the drop down list. To create a new qualifier, just add a preference and enter a new qualifier.");
        warning.setLayoutData((Object)new GridData(0x1000000, 16384, false, false));
        warning.setLayoutData((Object)new GridData(768));
        this.label = new Label(composite, 0);
        this.label.setText("Select Preference Qualifier/Group");
        this.qualifierCombo = new Combo(composite, 0);
        try {
            this.fillQualifierCombo();
            this.qualifierCombo.select(0);
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new UnhandledException((Throwable)e);
        }
        this.qualifierCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EditContextPrefsDialog.this.changePreferencesQualifier(EditContextPrefsDialog.this.qualifierCombo.getText());
            }
        });
        this.viewer = new TableViewer(composite, 2048);
        this.viewer.setContentProvider((IContentProvider)new PrefsContentProvider());
        this.nameColumn = this.createNameColumn();
        this.valueColumn = this.createValueColumn();
        this.viewer.setInput(this.prefSettings);
        this.viewer.setItemCount(this.prefSettings.size());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                KeyValuePair selectedValue = EditContextPrefsDialog.this.getSelectedPreferenceFromTable();
                if (selectedValue == null) {
                    return;
                }
                EditContextPrefsDialog.this.nameField.setText(selectedValue.name);
                EditContextPrefsDialog.this.valueField.setText(selectedValue.value);
                EditContextPrefsDialog.this.updateStatus(Status.OK_STATUS);
            }
        });
        this.viewer.getTable().setHeaderVisible(true);
        GridData tableData = new GridData(4, 4, true, true);
        tableData.horizontalSpan = 3;
        this.viewer.getTable().setLayoutData((Object)tableData);
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                EditContextPrefsDialog.this.validate();
            }
        };
        this.nameField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.qualifierField, this.nameField, this.valueField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.nameField.getTextControl(null));
        LayoutUtil.setHorizontalGrabbing((Control)this.valueField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        this.addOrUpdateButton = this.createButton(composite, "Add/Update Preference");
        this.addOrUpdateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                EditContextPrefsDialog.this.addOrUpdateButtonPressed();
            }
        });
        this.deleteButton = this.createButton(composite, "Delete Preference");
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                EditContextPrefsDialog.this.deleteButtonPressed();
            }
        });
        return composite;
    }

    private TableViewerColumn createNameColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)new PrefsLabelProvider(0));
        TableColumn column = result.getColumn();
        column.setText("Name");
        column.setWidth(370);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = EditContextPrefsDialog.updateSortDirection((TableColumn)event.widget);
                EditContextPrefsDialog.sort(EditContextPrefsDialog.this.viewer, 0, sortDirection == 1024);
            }
        });
        return result;
    }

    private TableViewerColumn createValueColumn() {
        TableViewerColumn result = new TableViewerColumn(this.viewer, 0);
        result.setLabelProvider((CellLabelProvider)new PrefsLabelProvider(1));
        TableColumn column = result.getColumn();
        column.setText("Value");
        column.setWidth(170);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int sortDirection = EditContextPrefsDialog.updateSortDirection((TableColumn)event.widget);
                EditContextPrefsDialog.sort(EditContextPrefsDialog.this.viewer, 1, sortDirection == 1024);
            }
        });
        return result;
    }

    protected void deleteButtonPressed() {
        KeyValuePair selectedValue = this.getSelectedPreferenceFromTable();
        if (selectedValue == null) {
            this.setError("Please select a preference!");
            return;
        }
        this.currentPrefNode.remove(selectedValue.name);
        try {
            this.currentPrefNode.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new UnhandledException((Throwable)e);
        }
        this.prefSettings.remove(selectedValue);
        this.viewer.setInput(this.prefSettings);
    }

    private void fillQualifierCombo() throws BackingStoreException {
        String[] childrenNames;
        this.prefQualifiers = new ArrayList<Preferences>();
        this.prefQualifiers.add(this.prefRootNode);
        String[] stringArray = childrenNames = this.prefRootNode.childrenNames();
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childNode = stringArray[n2];
            Preferences node = this.prefRootNode.node(childNode);
            this.prefQualifiers.add(node);
            ++n2;
        }
        this.qualifierCombo.setItems(this.toStringArray(this.prefQualifiers));
    }

    private KeyValuePair getSelectedPreferenceFromTable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof KeyValuePair) {
            return (KeyValuePair)selection.getFirstElement();
        }
        return null;
    }

    private void initContent() {
        try {
            String[] settingNames;
            String[] stringArray = settingNames = this.prefRootNode.keys();
            int n = settingNames.length;
            int n2 = 0;
            while (n2 < n) {
                String settingName = stringArray[n2];
                System.out.println(" ZK Pref " + settingName + ":" + this.prefRootNode.get(settingName, null));
                KeyValuePair pair = new KeyValuePair(settingName, this.prefRootNode.get(settingName, null));
                this.prefSettings.add(pair);
                ++n2;
            }
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
            throw new UnhandledException((Throwable)e);
        }
    }

    protected void okPressed() {
        super.okPressed();
    }

    void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.context", message));
        this.getShell().pack(true);
    }

    void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.context", message));
    }

    void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.context", message));
    }

    private String[] toStringArray(List<Preferences> prefQualifiers2) {
        ArrayList<String> list = new ArrayList<String>();
        for (Preferences preferences : prefQualifiers2) {
            list.add(preferences.name());
        }
        return list.toArray(new String[0]);
    }

    void validate() {
        this.updateStatus(Status.OK_STATUS);
    }

    private class KeyValuePair {
        public String name;
        public String value;

        public KeyValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    private static final class KeyValuePairComparator
    extends ViewerComparator
    implements Comparator<KeyValuePair> {
        private static final long serialVersionUID = 1L;
        private final boolean ascending;
        private final int property;

        public KeyValuePairComparator(int property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        @Override
        public int compare(KeyValuePair pair1, KeyValuePair pair22) {
            int result = 0;
            if (this.property == 0) {
                result = pair1.name.compareTo(pair22.name);
            } else if (this.property == 1) {
                result = pair1.value.compareTo(pair22.value);
            }
            if (!this.ascending) {
                result *= -1;
            }
            return result;
        }

        public int compare(Viewer viewer, Object object1, Object object2) {
            return this.compare((KeyValuePair)object1, (KeyValuePair)object2);
        }

        public boolean isSorterProperty(Object elem, String property) {
            return true;
        }
    }

    private static final class PrefsContentProvider
    implements IStructuredContentProvider {
        Object[] elements;

        private PrefsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput == null) {
                this.elements = new Object[0];
            } else {
                List preferenceList = (List)newInput;
                this.elements = preferenceList.toArray();
            }
        }
    }

    private class PrefsLabelProvider
    extends ColumnLabelProvider {
        private static final long serialVersionUID = 1L;
        private final int columnIndex;

        public PrefsLabelProvider(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public String getText(Object element) {
            KeyValuePair pref = (KeyValuePair)element;
            String result = pref.toString();
            switch (this.columnIndex) {
                case 0: {
                    result = pref.name;
                    break;
                }
                case 1: {
                    result = pref.value;
                }
            }
            return result;
        }
    }
}

