/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.locking;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.gyrex.cloud.internal.NodeInfo;
import org.eclipse.gyrex.cloud.internal.locking.DurableLockImpl;
import org.eclipse.gyrex.cloud.internal.locking.ExclusiveLockImpl;
import org.eclipse.gyrex.cloud.services.locking.IDurableLock;
import org.eclipse.gyrex.cloud.services.locking.IExclusiveLock;
import org.eclipse.gyrex.cloud.services.locking.ILockMonitor;
import org.eclipse.gyrex.cloud.services.locking.ILockService;

public class ZooKeeperLockService
implements ILockService {
    private final NodeInfo nodeInfo;

    public ZooKeeperLockService(NodeInfo nodeInfo) {
        Preconditions.checkArgument((nodeInfo != null ? 1 : 0) != 0, (Object)"node info must not be null");
        this.nodeInfo = nodeInfo;
    }

    @Override
    public IDurableLock acquireDurableLock(String lockId, ILockMonitor<IDurableLock> callback, long timeout) throws InterruptedException, TimeoutException {
        return new DurableLockImpl(this.nodeInfo, lockId, callback).acquire(timeout);
    }

    @Override
    public IExclusiveLock acquireExclusiveLock(String lockId, ILockMonitor<IExclusiveLock> callback, long timeout) throws InterruptedException, TimeoutException {
        return new ExclusiveLockImpl(this.nodeInfo, lockId, callback).acquire(timeout);
    }

    @Override
    public IStatus getDurableLockStatus(String lockId) {
        return new DurableLockImpl(this.nodeInfo, lockId, null).getStatus();
    }

    @Override
    public IStatus getExclusiveLockStatus(String lockId) {
        return new ExclusiveLockImpl(this.nodeInfo, lockId, null).getStatus();
    }

    @Override
    public IDurableLock recoverDurableLock(String lockId, ILockMonitor<IDurableLock> callback, String recoveryKey) throws IllegalArgumentException {
        return new DurableLockImpl(this.nodeInfo, lockId, callback).recover(recoveryKey);
    }
}

