/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.services;

import java.text.MessageFormat;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ServiceNotAvailableException
extends IllegalStateException {
    private static final long serialVersionUID = 1487250773530150148L;

    private static String getSymbolicName(BundleContext bundleContext) {
        Bundle bundle = null;
        try {
            bundle = bundleContext != null ? bundleContext.getBundle() : null;
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (bundle == null) {
            return "(destroyed)";
        }
        return MessageFormat.format("{0}(id {1})", bundle.getSymbolicName(), bundle.getBundleId());
    }

    public ServiceNotAvailableException(BundleContext bundleContext, String serviceInterfaceName) {
        this(bundleContext, serviceInterfaceName, null);
    }

    public ServiceNotAvailableException(BundleContext bundleContext, String serviceInterfaceClass, Throwable cause) {
        super(MessageFormat.format("Service ''{0}'' is currently not available for bundle ''{1}''", serviceInterfaceClass, ServiceNotAvailableException.getSymbolicName(bundleContext)), cause);
    }
}

