/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.gyrex.cloud.services.events.EventMessage;
import org.eclipse.gyrex.cloud.services.events.IEventReceiver;
import org.eclipse.gyrex.cloud.services.events.IEventTransport;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.eventbus.IEventBus;
import org.eclipse.gyrex.eventbus.IEventDeserializer;
import org.eclipse.gyrex.eventbus.IEventSerializer;
import org.eclipse.gyrex.eventbus.internal.ByteArrayDeSerializer;
import org.eclipse.gyrex.eventbus.internal.ByteBufferDeSerializer;
import org.eclipse.gyrex.eventbus.internal.ReflectionService;
import org.eclipse.gyrex.eventbus.internal.StringDeSerializer;
import org.eclipse.gyrex.eventbus.internal.Topic;
import org.eclipse.gyrex.eventbus.internal.TopicBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventService
implements IEventBus {
    private static final Logger LOG = LoggerFactory.getLogger(EventService.class);
    private final ReflectionService reflectionService = new ReflectionService();
    private final String nodeId;
    private final AtomicLong eventCounter = new AtomicLong(0L);
    private final IServiceProxy<IEventTransport> transportServiceProxy;
    private final ExecutorService sendExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "EventService-SendThread");
            t.setDaemon(true);
            return t;
        }
    });
    private final ConcurrentMap<Topic, TopicEventReceiver> activeTopics = new ConcurrentHashMap<Topic, TopicEventReceiver>();
    private volatile boolean disposed;

    public EventService(String nodeId, IServiceProxy<IEventTransport> transportServiceProxy) {
        this.nodeId = (String)Preconditions.checkNotNull((Object)nodeId);
        this.transportServiceProxy = (IServiceProxy)Preconditions.checkNotNull(transportServiceProxy);
    }

    void activateTopic(Topic topic) {
        this.checkDisposed();
        TopicEventReceiver receiver = new TopicEventReceiver(topic);
        if (this.activeTopics.putIfAbsent(topic, receiver) == null) {
            LOG.debug("Subscribing topic ({}).", (Object)topic);
            this.getTransport().subscribeTopic(topic.getId(), (IEventReceiver)receiver, null);
        }
    }

    private void checkDisposed() {
        Preconditions.checkState((!this.disposed ? 1 : 0) != 0, (Object)"disposed");
    }

    void deactivateTopic(Topic topic) {
        TopicEventReceiver receiver = (TopicEventReceiver)this.activeTopics.remove(topic);
        if (receiver != null) {
            LOG.debug("Unsubscribing topic ({}).", (Object)topic);
            this.getTransport().unsubscribeTopic(topic.getId(), (IEventReceiver)receiver, null);
        }
    }

    public void dispose() {
        this.disposed = true;
        while (this.activeTopics.size() > 0) {
            this.deactivateTopic((Topic)this.activeTopics.keySet().iterator().next());
        }
    }

    ReflectionService getReflectionService() {
        return this.reflectionService;
    }

    @Override
    public TopicBuilder getTopic(String id) throws IllegalArgumentException, IllegalStateException {
        this.checkDisposed();
        return ((TopicBuilder)((TopicBuilder)((TopicBuilder)((TopicBuilder)((TopicBuilder)new TopicBuilder(id, this).addSerializer(new IEventSerializer[]{ByteArrayDeSerializer.sharedInstance})).addSerializer(new IEventSerializer[]{ByteBufferDeSerializer.sharedInstance})).addSerializer(new IEventSerializer[]{StringDeSerializer.sharedInstance})).addDeserializer(new IEventDeserializer[]{ByteArrayDeSerializer.sharedInstance})).addDeserializer(new IEventDeserializer[]{ByteBufferDeSerializer.sharedInstance})).addDeserializer(new IEventDeserializer[]{StringDeSerializer.sharedInstance});
    }

    @VisibleForTesting
    IEventTransport getTransport() {
        return (IEventTransport)this.transportServiceProxy.getService();
    }

    String newEventId() {
        return String.valueOf(this.nodeId) + "-" + this.nextId();
    }

    long nextId() {
        long next;
        long last;
        while (!this.eventCounter.compareAndSet(last, next = (last = this.eventCounter.get()) == Long.MAX_VALUE ? 0L : last + 1L)) {
        }
        return next;
    }

    public void queueEvent(String topciId, EventMessage eventMessage) {
        if (this.transportServiceProxy.isAvailable()) {
            LOG.trace("Queuing event ({}, topic {}) for delivery.", (Object)eventMessage.getId(), (Object)topciId);
            this.sendExecutor.execute(new SendEvent(topciId, eventMessage));
        } else {
            LOG.trace("Discarding event ({}, topic {}). No transport available.", (Object)eventMessage.getId(), (Object)topciId);
        }
    }

    class SendEvent
    implements Runnable {
        private final String topciId;
        private final EventMessage message;

        SendEvent(String topciId, EventMessage message) {
            this.topciId = topciId;
            this.message = message;
        }

        @Override
        public void run() {
            try {
                LOG.trace("Sending event ({}, topic {}).", (Object)this.message.getId(), (Object)this.topciId);
                EventService.this.getTransport().sendEvent(this.topciId, this.message, Collections.emptyMap());
            }
            catch (AssertionError | LinkageError | RuntimeException e) {
                LOG.warn("Unable to send event ({}) for topic ({}). Event discarded. {}", new Object[]{this.message.getId(), this.topciId, ((Throwable)e).getMessage(), e});
            }
        }
    }

    static class TopicEventReceiver
    implements IEventReceiver {
        private final Topic topic;

        TopicEventReceiver(Topic topic) {
            this.topic = topic;
        }

        public void receiveEvent(EventMessage eventMessage) {
            this.topic.dispatchEvent(eventMessage);
        }
    }
}

