/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.installer;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.gyrex.p2.internal.P2Debug;
import org.eclipse.gyrex.p2.internal.installer.PackageScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallerApplication
implements IApplication {
    private static final Logger LOG = LoggerFactory.getLogger(InstallerApplication.class);
    private static final AtomicReference<PackageScanner> jobRef = new AtomicReference();
    private final AtomicReference<IApplicationContext> contextRef = new AtomicReference();

    public Object start(IApplicationContext context) throws Exception {
        PackageScanner job = PackageScanner.getInstance();
        if (!jobRef.compareAndSet(null, job)) {
            throw new IllegalStateException("installer application already started");
        }
        if (P2Debug.nodeInstallation) {
            LOG.debug("Scheduling package scanner to check for new packages now.");
        }
        job.schedule();
        context.applicationRunning();
        this.contextRef.set(context);
        return IApplicationContext.EXIT_ASYNC_RESULT;
    }

    public void stop() {
        PackageScanner job = jobRef.getAndSet(null);
        if (job == null) {
            return;
        }
        job.cancel();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        IApplicationContext context = this.contextRef.getAndSet(null);
        if (context != null) {
            context.setResult((Object)EXIT_OK, (IApplication)this);
        }
    }
}

