/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemHeaders;
import org.apache.commons.fileupload.FileItemHeadersSupport;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IUploadAdapter;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServerPushSession;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.widgets.FileUpload;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class UploadDialogField
extends DialogField {
    final AtomicReference<UploadHandler> uploadHandlerRef = new AtomicReference();
    private String uploadButtonLabel = "Browse...";
    private Text fileText;
    private FileUpload uploadControl;
    private boolean uploadInProgress;
    private String fileName = "";

    protected static GridData gridDataForUpload(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)UploadDialogField.gridDataForLabel(1));
        Text text = this.getFileTextControl(parent);
        text.setLayoutData((Object)StringDialogField.gridDataForText(nColumns - 2));
        FileUpload upload = this.getUploadControl(parent);
        upload.setLayoutData((Object)UploadDialogField.gridDataForUpload(1));
        return new Control[]{label, text, upload};
    }

    private void doModifyFileName() {
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.fileName = StringUtils.trimToEmpty((String)this.uploadControl.getFileName());
            this.fileText.setText(this.fileName);
        }
        this.dialogFieldChanged();
    }

    public String getFileName() {
        return this.fileName;
    }

    public Text getFileTextControl(Composite parent) {
        if (this.fileText == null) {
            this.assertCompositeNotNull(parent);
            this.fileText = new Text(parent, 2052);
            this.fileText.setText(this.fileName);
            this.fileText.setToolTipText("Selected file");
            this.fileText.setEditable(false);
            this.fileText.setFont(parent.getFont());
            this.fileText.setEnabled(this.isEnabled());
        }
        return this.fileText;
    }

    @Override
    public int getNumberOfControls() {
        return 3;
    }

    public FileUpload getUploadControl(Composite parent) {
        if (this.uploadControl == null) {
            this.assertCompositeNotNull(parent);
            this.uploadControl = new FileUpload(parent, 0);
            this.uploadControl.setText(this.uploadButtonLabel);
            this.uploadControl.setToolTipText("Select a file");
            this.uploadControl.setFont(parent.getFont());
            this.uploadControl.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = 1L;

                public void widgetSelected(SelectionEvent e) {
                    UploadDialogField.this.doModifyFileName();
                }
            });
        }
        return this.uploadControl;
    }

    @Override
    public void refresh() {
        super.refresh();
        this.isOkToUse((Control)this.uploadControl);
    }

    @Override
    public boolean setFocus() {
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setFocus();
        }
        return true;
    }

    public void setUploadButtonLabel(String uploadButtonLabel) {
        this.uploadButtonLabel = uploadButtonLabel;
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setText(uploadButtonLabel);
        }
    }

    public void startUpload(IUploadAdapter receiver) {
        this.uploadInProgress = true;
        this.updateEnableState();
        final ServerPushSession pushSession = new ServerPushSession();
        final UploadHandler handler = new UploadHandler(receiver);
        this.uploadControl.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                handler.dispose();
                pushSession.stop();
            }
        });
        final Display display = this.uploadControl.getDisplay();
        String url = handler.getUploadUrl();
        handler.setListener(new IUploadHandlerListener(){

            @Override
            public void uploadFailed(final Throwable e) {
                handler.dispose();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UploadDialogField.this.fileText.setText(String.format("ERROR: %s", ExceptionUtils.getRootCauseMessage((Throwable)e)));
                        UploadDialogField.this.uploadInProgress = false;
                        UploadDialogField.this.setUploadButtonLabel(UploadDialogField.this.uploadButtonLabel);
                        UploadDialogField.this.updateEnableState();
                        pushSession.stop();
                    }
                });
            }

            @Override
            public void uploadFinished(String fileName) {
                handler.dispose();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (UploadDialogField.this.isOkToUse((Control)UploadDialogField.this.fileText)) {
                            UploadDialogField.this.fileText.setText(UploadDialogField.this.getFileName());
                        }
                        UploadDialogField.this.uploadInProgress = false;
                        UploadDialogField.this.setUploadButtonLabel(UploadDialogField.this.uploadButtonLabel);
                        UploadDialogField.this.updateEnableState();
                        pushSession.stop();
                    }
                });
            }
        });
        pushSession.start();
        this.uploadControl.setText("Uploading...");
        this.uploadControl.submit(url);
    }

    @Override
    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fileText)) {
            this.fileText.setEnabled(this.isEnabled());
        }
        if (this.isOkToUse((Control)this.uploadControl)) {
            this.uploadControl.setEnabled(this.isEnabled() && !this.uploadInProgress);
        }
    }

    private static interface IUploadHandlerListener {
        public void uploadFailed(Throwable var1);

        public void uploadFinished(String var1);
    }

    private final class UploadHandler
    implements ServiceHandler {
        final Pattern jSessionIdPattern = Pattern.compile(";jsessionid=[a-z0-9A-Z]+");
        private final String handlerId;
        private final IUploadAdapter uploadAdapter;
        private IUploadHandlerListener listener;

        public UploadHandler(IUploadAdapter uploadAdapter) {
            this.uploadAdapter = uploadAdapter;
            this.handlerId = String.valueOf(UploadHandler.class.getName()) + "@" + System.identityHashCode(this);
            if (!UploadDialogField.this.uploadHandlerRef.compareAndSet(null, this)) {
                throw new IllegalStateException("Concurrent upload in progress!");
            }
            RWT.getServiceManager().registerServiceHandler(this.handlerId, (ServiceHandler)this);
        }

        public void dispose() {
            UploadDialogField.this.uploadHandlerRef.compareAndSet(this, null);
            RWT.getServiceManager().unregisterServiceHandler(this.handlerId);
        }

        private long getContentLength(FileItemHeadersSupport itemWithHeaders) {
            FileItemHeaders headers = itemWithHeaders.getHeaders();
            return NumberUtils.toLong((String)(headers != null ? headers.getHeader("Content-length") : null), (long)-1L);
        }

        public String getUploadUrl() {
            String requestURI = this.jSessionIdPattern.matcher(RWT.getRequest().getRequestURI()).replaceAll("");
            String serviceHandlerUrl = this.jSessionIdPattern.matcher(RWT.getServiceManager().getServiceHandlerUrl(this.handlerId)).replaceAll("");
            if (!serviceHandlerUrl.startsWith(requestURI)) {
                return RWT.getResponse().encodeURL(String.valueOf(requestURI) + serviceHandlerUrl);
            }
            return RWT.getResponse().encodeURL(serviceHandlerUrl);
        }

        public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            boolean hasSession;
            boolean bl = hasSession = request.getSession(false) != null;
            if (!hasSession) {
                response.sendError(400);
                return;
            }
            if (!"POST".equals(request.getMethod().toUpperCase())) {
                response.sendError(405);
                return;
            }
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                response.sendError(415);
                return;
            }
            ServletFileUpload servletFileUpload = new ServletFileUpload();
            servletFileUpload.setFileSizeMax(0x500000L);
            try {
                FileItemIterator itemIterator = servletFileUpload.getItemIterator(request);
                while (itemIterator.hasNext()) {
                    FileItemStream item = itemIterator.next();
                    if (item.isFormField()) continue;
                    InputStream stream = item.openStream();
                    try {
                        this.uploadAdapter.receive(stream, item.getName(), item.getContentType(), this.getContentLength((FileItemHeadersSupport)item));
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)stream);
                    }
                    try {
                        if (this.listener != null) {
                            this.listener.uploadFinished(item.getName());
                        }
                    }
                    finally {
                        this.dispose();
                    }
                    return;
                }
            }
            catch (VirtualMachineError e) {
                throw e;
            }
            catch (Throwable t) {
                if (this.listener != null) {
                    this.listener.uploadFailed(t);
                }
                throw new ServletException("Error retrieving files.", t);
            }
            response.sendError(400);
        }

        public void setListener(IUploadHandlerListener listener) {
            this.listener = listener;
        }
    }
}

