/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.cloud.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingStatusDialog;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.Separator;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.StringDialogField;
import org.eclipse.gyrex.cloud.admin.ICloudManager;
import org.eclipse.gyrex.cloud.admin.INodeConfigurer;
import org.eclipse.gyrex.cloud.admin.INodeDescriptor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditNodeDialog
extends NonBlockingStatusDialog {
    private static final long serialVersionUID = 1L;
    private final StringDialogField idField = new StringDialogField();
    private final StringDialogField nameField = new StringDialogField();
    private final StringDialogField locationField = new StringDialogField();
    private final StringDialogField tagsField = new StringDialogField();
    private final StringDialogField addressesField = new StringDialogField();
    private final ICloudManager cloudManager;
    private final INodeDescriptor nodeDescriptor;

    public EditNodeDialog(Shell parent, ICloudManager cloudManager, INodeDescriptor nodeDescriptor) {
        super(parent);
        this.cloudManager = cloudManager;
        this.nodeDescriptor = nodeDescriptor;
        this.setTitle("Edit Node Info");
        this.setShellStyle(67696);
        this.idField.setText(nodeDescriptor.getId());
        this.nameField.setText(nodeDescriptor.getName());
        this.locationField.setText(nodeDescriptor.getLocation());
        this.tagsField.setText(StringUtils.join((Collection)nodeDescriptor.getTags(), (String)", "));
        this.addressesField.setText(StringUtils.join((Collection)nodeDescriptor.getAddresses(), (String)", "));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)composite.getLayoutData();
        gd.minimumHeight = this.convertVerticalDLUsToPixels(200);
        gd.minimumWidth = this.convertHorizontalDLUsToPixels(400);
        this.idField.setLabelText("Id");
        this.nameField.setLabelText("Name");
        this.locationField.setLabelText("Location");
        this.tagsField.setLabelText("Tags");
        this.addressesField.setLabelText("Addresses");
        this.idField.setEnabled(false);
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                EditNodeDialog.this.validate();
            }
        };
        this.idField.setDialogFieldListener(validateListener);
        this.nameField.setDialogFieldListener(validateListener);
        this.locationField.setDialogFieldListener(validateListener);
        this.tagsField.setDialogFieldListener(validateListener);
        this.addressesField.setDialogFieldListener(validateListener);
        Text warning = new Text(composite, 72);
        warning.setText("Warning: this dialog is ugly. Please help us improve the UI. Any mockups and/or patches are very much appreciated!");
        warning.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{new Separator(), this.idField, this.nameField, this.locationField, this.addressesField, this.tagsField}, (boolean)false);
        LayoutUtil.setHorizontalGrabbing((Control)this.idField.getTextControl(null));
        GridLayout masterLayout = (GridLayout)composite.getLayout();
        masterLayout.marginWidth = 5;
        masterLayout.marginHeight = 5;
        LayoutUtil.setHorizontalSpan((Control)warning, (int)masterLayout.numColumns);
        return composite;
    }

    protected void okPressed() {
        this.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        try {
            INodeConfigurer nodeConfigurer = this.cloudManager.getNodeConfigurer(this.nodeDescriptor.getId());
            nodeConfigurer.setName(this.nameField.getText());
            nodeConfigurer.setLocation(this.locationField.getText());
            String[] tags = StringUtils.split((String)this.tagsField.getText(), (char)',');
            HashSet<String> cleanedTags = new HashSet<String>();
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                if ((tag = StringUtils.trimToNull((String)tag)) != null) {
                    cleanedTags.add(tag);
                }
                ++n2;
            }
            nodeConfigurer.setTags(cleanedTags);
            String[] addresses = StringUtils.split((String)this.addressesField.getText(), (char)',');
            ArrayList<String> cleanedAddresses = new ArrayList<String>();
            String[] stringArray2 = addresses;
            int n3 = addresses.length;
            int n4 = 0;
            while (n4 < n3) {
                String address = stringArray2[n4];
                if ((address = StringUtils.trimToNull((String)address)) != null && !cleanedAddresses.contains(address)) {
                    cleanedAddresses.add(address);
                }
                ++n4;
            }
            nodeConfigurer.setAddesses(cleanedAddresses);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            return;
        }
        super.okPressed();
    }

    protected void setError(String message) {
        this.updateStatus((IStatus)new Status(4, "org.eclipse.gyrex.admin.ui.cloud", message));
        this.getShell().pack(true);
    }

    protected void setInfo(String message) {
        this.updateStatus((IStatus)new Status(1, "org.eclipse.gyrex.admin.ui.cloud", message));
    }

    protected void setWarning(String message) {
        this.updateStatus((IStatus)new Status(2, "org.eclipse.gyrex.admin.ui.cloud", message));
    }

    void validate() {
        this.updateStatus(Status.OK_STATUS);
    }
}

