/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.cloud.internal.queue.console;

import org.eclipse.gyrex.cloud.internal.CloudActivator;
import org.eclipse.gyrex.cloud.internal.queue.ZooKeeperQueueService;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.kohsuke.args4j.Argument;

public class RemoveQueueCmd
extends Command {
    @Argument(index=0, metaVar="QUEUEID", usage="id of the queue")
    String queueId;

    public RemoveQueueCmd() {
        super("<QUEUEID> - removes a queue");
    }

    protected void doExecute() throws Exception {
        if (!IdHelper.isValidId((String)this.queueId)) {
            this.printf("ERROR: Invalid queue id!", new Object[0]);
            return;
        }
        this.getQueueService().deleteQueue(this.queueId, null);
    }

    private ZooKeeperQueueService getQueueService() {
        return (ZooKeeperQueueService)CloudActivator.getInstance().getService(IQueueService.class);
    }
}

