/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IModifiableRuntimeContext;
import org.eclipse.gyrex.jobs.IJobContext;
import org.eclipse.gyrex.jobs.annotation.JobType;
import org.eclipse.gyrex.jobs.internal.JobsDebug;
import org.eclipse.gyrex.jobs.internal.util.BundleAnnotatedClassScanner;
import org.eclipse.gyrex.jobs.provider.JobProvider;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanningJobProviderComponent
extends JobProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningJobProviderComponent.class);
    private volatile Map<String, Class<Job>> jobClassesByTypeId;

    public void activate(ComponentContext context) {
        if (JobsDebug.scanningProvider) {
            LOG.debug("ScanningJobProviderComponent activation triggered for component '{}' (bundle {})", context.getProperties().get("component.name"), (Object)context.getBundleContext().getBundle());
        }
        HashMap<String, Class<Job>> jobClassesByTypeId = new HashMap<String, Class<Job>>();
        Set<Class<?>> foundClasses = new BundleAnnotatedClassScanner(context.getBundleContext().getBundle(), JobType.class).scan();
        for (Class<?> clazz : foundClasses) {
            JobType jobProvider = clazz.getAnnotation(JobType.class);
            if (!IdHelper.isValidId((String)jobProvider.typeId())) {
                throw new IllegalStateException(String.format("Invalid job type id (%s) found. Please check your component configuration!", jobProvider.typeId()));
            }
            if (!Job.class.isAssignableFrom(clazz)) {
                throw new IllegalStateException(String.format("Job type class (%s) must be a sub-class of org.eclipse.core.runtime.jobs.Job but it isn't. Please check your component configuration!", clazz));
            }
            if (JobsDebug.scanningProvider) {
                LOG.debug("Found job type '{}' using class '{}' for component '{}' (bundle {})", new Object[]{jobProvider.typeId(), clazz, context.getProperties().get("component.name"), context.getBundleContext().getBundle()});
            }
            jobClassesByTypeId.put(jobProvider.typeId(), clazz);
        }
        this.jobClassesByTypeId = jobClassesByTypeId;
    }

    @Override
    public Job createJob(String typeId, IJobContext context) throws Exception {
        Map<String, Class<Job>> jobClassesByTypeId = this.jobClassesByTypeId;
        if (jobClassesByTypeId == null) {
            LOG.debug("Job provider is inactive! It either hasn't been started yet or it's shutting down.");
            return null;
        }
        Class<Job> clazz = jobClassesByTypeId.get(typeId);
        if (clazz == null) {
            LOG.debug("No class found for job type '{}'.", (Object)typeId);
            return null;
        }
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (IModifiableRuntimeContext runtimeContext = context.getContext().createWorkingCopy();){
                runtimeContext.setLocal(IJobContext.class, (Object)context);
                runtimeContext.setLocal(Logger.class, (Object)context.getLogger());
                return (Job)runtimeContext.getInjector().make(clazz);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            if (StringUtils.contains((String)e.getMessage(), (String)"no actual value was found for the argument")) {
                throw new IllegalArgumentException("Please verify the job configuration. Not all required parameter seems to be available.", e);
            }
            throw e;
        }
    }

    public void deactivate(ComponentContext context) {
        if (JobsDebug.scanningProvider) {
            LOG.debug("ScanningJobProviderComponent de-activation triggered for component '{}' (bundle {})", context.getProperties().get("component.name"), (Object)context.getBundleContext().getBundle());
        }
        this.jobClassesByTypeId = null;
    }

    @Override
    List<String> discoverProvidedTypeIds() {
        Map<String, Class<Job>> jobClassesByTypeId = this.jobClassesByTypeId;
        if (jobClassesByTypeId == null) {
            throw new IllegalStateException("inactive");
        }
        return new ArrayList<String>(jobClassesByTypeId.keySet());
    }
}

