/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardAdapter;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardSession;
import org.eclipse.gyrex.admin.ui.logback.internal.AppenderWizardPage;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.gyrex.logback.config.model.LogbackConfig;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddEditAppenderWizard
extends Wizard {
    private static final Logger LOG = LoggerFactory.getLogger(AddEditAppenderWizard.class);
    private static final IWizardPage[] NO_PAGES = new IWizardPage[0];
    private final Map<String, AppenderConfigurationWizardSession> sessionsByAppenderTypeId = new HashMap<String, AppenderConfigurationWizardSession>(2);
    private final LogbackConfig logbackConfig;
    private final Appender appender;
    private final AppenderWizardPage appenderTypeWizardPage;
    private AppenderConfigurationWizardSession currentSession;

    public AddEditAppenderWizard(LogbackConfig logbackConfig, Appender appender) {
        this.logbackConfig = logbackConfig;
        this.appender = appender;
        this.appenderTypeWizardPage = new AppenderWizardPage(appender);
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.appenderTypeWizardPage);
    }

    public boolean canFinish() {
        return this.appenderTypeWizardPage.isPageComplete() && this.currentSession != null && this.currentSession.canFinish();
    }

    void clearCurrentAppenderConfigurationSession() {
        this.currentSession = null;
        this.getContainer().showPage((IWizardPage)this.appenderTypeWizardPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage[] sessionPages;
        IWizardPage[] iWizardPageArray = sessionPages = this.currentSession != null ? this.currentSession.getPages() : NO_PAGES;
        if (page == this.appenderTypeWizardPage) {
            if (sessionPages.length > 0) {
                return sessionPages[0];
            }
            return null;
        }
        int i = 0;
        while (i < sessionPages.length) {
            if (page == sessionPages[i]) {
                if (i + 1 < sessionPages.length) {
                    return sessionPages[i + 1];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        IWizardPage[] sessionPages;
        IWizardPage[] iWizardPageArray = sessionPages = this.currentSession != null ? this.currentSession.getPages() : NO_PAGES;
        if (page == this.appenderTypeWizardPage) {
            return null;
        }
        int i = sessionPages.length - 1;
        while (i >= 0) {
            if (page == sessionPages[i]) {
                if (i - 1 >= 0) {
                    return sessionPages[i - 1];
                }
                return this.isEditMode() ? null : this.appenderTypeWizardPage;
            }
            --i;
        }
        return null;
    }

    public LogbackConfig getSchedule() {
        return this.logbackConfig;
    }

    public Appender getScheduleEntry() {
        return this.appender;
    }

    void initializeCurrentAppenderConfigurationSession(String id, String name, AppenderConfigurationWizardAdapter wizardAdapter) {
        AppenderConfigurationWizardSession session;
        if (!this.sessionsByAppenderTypeId.containsKey(id)) {
            session = new AppenderConfigurationWizardSession(id, name);
            session.setAppender(this.appender);
            this.sessionsByAppenderTypeId.put(id, session);
        }
        if ((session = this.sessionsByAppenderTypeId.get(id)) == this.currentSession) {
            return;
        }
        if (session.getPages() == null) {
            IWizardPage[] pages;
            IWizardPage[] iWizardPageArray = pages = wizardAdapter != null ? wizardAdapter.createPages(session) : new IWizardPage[]{};
            if (pages != null) {
                session.setPages(pages);
                IWizardPage[] iWizardPageArray2 = pages;
                int n = pages.length;
                int n2 = 0;
                while (n2 < n) {
                    IWizardPage page = iWizardPageArray2[n2];
                    this.addPage(page);
                    ++n2;
                }
            } else {
                LOG.debug("No pages returned for job type {} (adapter {})", (Object)id, (Object)wizardAdapter);
                session.setPages(NO_PAGES);
            }
        }
        this.currentSession = session;
        if (this.getContainer().getCurrentPage() != null) {
            this.getContainer().updateButtons();
        }
    }

    public final boolean isEditMode() {
        return this.appender != null;
    }

    public boolean performFinish() {
        return true;
    }
}

