/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.websocket.internal;

import java.nio.ByteBuffer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.cloud.services.events.EventMessage;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventMessageSender
extends WebSocketAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(EventMessageSender.class);
    private final String localINodeId;
    final ByteBufferPool bufferPool = new ArrayByteBufferPool(1, 50, 100);

    EventMessageSender(String localINodeId) {
        this.localINodeId = localINodeId;
    }

    public void onWebSocketClose(int statusCode, String reason) {
        super.onWebSocketClose(statusCode, reason);
    }

    public void sendEvent(String topic, final EventMessage message) {
        final ByteBuffer buffer = this.bufferPool.acquire(this.getSession().getPolicy().getMaxBinaryMessageSize(), false);
        buffer.clear();
        this.writeUtf8String(buffer, message.getId());
        this.writeUtf8String(buffer, topic);
        this.writeUtf8String(buffer, message.getType());
        this.writeUtf8String(buffer, this.localINodeId);
        buffer.put(message.getPayload().slice());
        buffer.flip();
        this.getRemote().sendBytes(buffer, new WriteCallback(){

            public void writeFailed(Throwable x) {
                LOG.error("Error writing event ({}) to ({}). {}", new Object[]{message.getId(), EventMessageSender.this.getSession(), ExceptionUtils.getRootCauseMessage((Throwable)x), x});
                EventMessageSender.this.bufferPool.release(buffer);
            }

            public void writeSuccess() {
                EventMessageSender.this.bufferPool.release(buffer);
            }
        });
    }

    private void writeUtf8String(ByteBuffer buffer, String string) {
        buffer.putInt(string.length());
        buffer.put(StringUtil.getUtf8Bytes((String)string));
    }
}

