/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.mongodb.internal.jpa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.ErrorMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.monitoring.metrics.StatusMetric;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;

public class MongoDbJpaRepositoryMetrics
extends MetricSet {
    private final StatusMetric statusMetric = (StatusMetric)this.getMetric(0, StatusMetric.class);
    private final ErrorMetric errorMetric = (ErrorMetric)this.getMetric(1, ErrorMetric.class);

    private static BaseMetric[] createMetrics(String initialStatus, String initialStatusReason) {
        ArrayList<Object> metrics = new ArrayList<Object>(6);
        metrics.add(new StatusMetric("status", initialStatus, initialStatusReason));
        metrics.add(new ErrorMetric("error", 5));
        return metrics.toArray(new BaseMetric[metrics.size()]);
    }

    private static Map<String, String> createProperties(String repositoryId, RepositoryProvider repositoryProvider) {
        HashMap<String, String> properties = new HashMap<String, String>(4);
        properties.put("repository.id", repositoryId);
        properties.put("repository.provider.id", repositoryProvider.getProviderId());
        return properties;
    }

    public MongoDbJpaRepositoryMetrics(String id, String repositoryId, RepositoryProvider repositoryProvider, String initialStatus, String initialStatusReason) {
        super(id, String.format("Repository metrics for EclipseLink repository '%s'", repositoryId), MongoDbJpaRepositoryMetrics.createProperties(repositoryId, repositoryProvider), MongoDbJpaRepositoryMetrics.createMetrics(initialStatus, initialStatusReason));
    }

    public ErrorMetric getErrorMetric() {
        return this.errorMetric;
    }

    public StatusMetric getStatusMetric() {
        return this.statusMetric;
    }

    public void setClosed(String reason) {
        this.getStatusMetric().setStatus("closed", reason);
    }
}

