/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.search.solr.tests;

import java.util.Locale;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.gyrex.search.ISearchManager;
import org.eclipse.gyrex.search.facets.IFacet;
import org.eclipse.gyrex.search.internal.solr.facets.Facet;
import org.eclipse.gyrex.search.query.FacetSelectionStrategy;
import org.eclipse.gyrex.search.query.TermCombination;
import org.eclipse.gyrex.search.solr.tests.BaseSolrTest;
import org.junit.Test;

public class SolrFacetTest
extends BaseSolrTest {
    private static final String TEST_FACET = "Test Facet";

    @Test
    public void test001_FacetSerialization() throws Exception {
        Facet facet = new Facet("test", null);
        facet.setName("Test");
        facet.setName("Test de", Locale.GERMAN);
        facet.setName("Test de_DE", Locale.GERMANY);
        Assert.assertEquals((String)"Test de_DE", (String)facet.getName(new Locale[]{Locale.GERMANY}));
        Assert.assertEquals((String)"Test de", (String)facet.getName(new Locale[]{Locale.GERMAN}));
        Assert.assertEquals((String)"Test de_DE", (String)facet.getName(new Locale[]{Locale.GERMANY, Locale.GERMAN}));
        Assert.assertEquals((String)"Test", (String)facet.getName(new Locale[]{Locale.UK, Locale.ROOT}));
        Assert.assertNull((Object)facet.getName(new Locale[]{Locale.UK}));
        byte[] bs = facet.toByteArray();
        Facet facet2 = new Facet("test", null, bs);
        Assert.assertEquals((String)facet.getName(), (String)facet2.getName());
        Assert.assertNull((Object)facet2.getSelectionStrategy());
        Assert.assertNull((Object)facet2.getTermCombination());
        Assert.assertEquals((String)facet.getName(new Locale[]{Locale.GERMANY}), (String)facet2.getName(new Locale[]{Locale.GERMANY}));
        Assert.assertEquals((String)facet.getName(new Locale[]{Locale.GERMAN}), (String)facet2.getName(new Locale[]{Locale.GERMAN}));
        Assert.assertEquals((String)facet.getName(new Locale[]{Locale.GERMANY, Locale.GERMAN}), (String)facet2.getName(new Locale[]{Locale.GERMANY, Locale.GERMAN}));
        Assert.assertEquals((String)facet.getName(new Locale[]{Locale.UK, Locale.ROOT}), (String)facet2.getName(new Locale[]{Locale.UK, Locale.ROOT}));
        Assert.assertNull((Object)facet2.getName(new Locale[]{Locale.UK}));
    }

    @Test
    public void test002_ManagerBasics() throws Exception {
        IFacet facet2;
        ISearchManager manager = (ISearchManager)this.getContext().get(ISearchManager.class);
        Assert.assertNotNull((Object)manager);
        Map existingFacets = manager.getFacets();
        Assert.assertNotNull((Object)existingFacets);
        if (!existingFacets.isEmpty()) {
            for (IFacet facet2 : existingFacets.values()) {
                manager.deleteFacet(facet2);
                Assert.assertNotNull((Object)manager.getFacets());
                Assert.assertFalse((boolean)manager.getFacets().containsKey(facet2.getAttributeId()));
            }
        }
        Assert.assertNotNull((Object)manager.getFacets());
        Assert.assertTrue((boolean)manager.getFacets().isEmpty());
        facet2 = manager.createFacet("test");
        Assert.assertNotNull((Object)facet2);
        Assert.assertNotNull((Object)manager.getFacets());
        Assert.assertFalse((boolean)manager.getFacets().containsKey(facet2.getAttributeId()));
        manager.saveFacet(facet2);
        Assert.assertNotNull((Object)manager.getFacets());
        Assert.assertEquals((int)1, (int)manager.getFacets().size());
        Assert.assertTrue((boolean)manager.getFacets().containsKey(facet2.getAttributeId()));
    }

    @Test
    public void test003_FacetPersistence() throws Exception {
        ISearchManager manager = (ISearchManager)this.getContext().get(ISearchManager.class);
        Assert.assertNotNull((Object)manager);
        IFacet facet = manager.createFacet("test");
        Assert.assertNotNull((Object)facet);
        facet.setName(TEST_FACET);
        Assert.assertEquals((String)facet.getName(), (String)TEST_FACET);
        facet.setSelectionStrategy(FacetSelectionStrategy.MULTI);
        Assert.assertEquals((Object)facet.getSelectionStrategy(), (Object)FacetSelectionStrategy.MULTI);
        facet.setTermCombination(TermCombination.AND);
        Assert.assertEquals((Object)facet.getTermCombination(), (Object)TermCombination.AND);
        manager.saveFacet(facet);
        IFacet saveFacet = (IFacet)manager.getFacets().get(facet.getAttributeId());
        Assert.assertNotNull((Object)saveFacet);
        Assert.assertNotSame((Object)facet, (Object)saveFacet);
        Assert.assertEquals((String)facet.getName(), (String)saveFacet.getName());
        Assert.assertEquals((Object)facet.getSelectionStrategy(), (Object)saveFacet.getSelectionStrategy());
        Assert.assertEquals((Object)facet.getTermCombination(), (Object)saveFacet.getTermCombination());
    }
}

