/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.commands;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.p2.internal.commands.BaseSwCmd;
import org.eclipse.gyrex.p2.internal.repositories.RepositoryDefinition;
import org.kohsuke.args4j.Argument;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;

public final class AddRepoCmd
extends BaseSwCmd {
    @Argument(index=0, usage="the repository id", required=true, metaVar="ID")
    String id;
    @Argument(index=1, usage="the repository URI", required=true, metaVar="URI")
    String uri;
    @Argument(index=2, usage="an optional node filter", required=false, metaVar="FILTER")
    String filter;

    public AddRepoCmd() {
        super("<id> <uri> [filter] - adds a repository");
    }

    protected void doExecute() throws Exception {
        URI location;
        if (!IdHelper.isValidId((String)this.id)) {
            this.printf("ERROR: invalid repo id", new Object[0]);
            return;
        }
        try {
            location = new URI(this.uri);
        }
        catch (URISyntaxException e) {
            this.printf("ERROR: invalid uri: %s", new Object[]{e.getMessage()});
            return;
        }
        RepositoryDefinition repo = new RepositoryDefinition();
        repo.setId(this.id);
        repo.setLocation(location);
        if (StringUtils.isNotBlank((String)this.filter)) {
            try {
                FrameworkUtil.createFilter((String)this.filter);
            }
            catch (InvalidSyntaxException e) {
                this.printf("ERROR: invalid filter: %s", new Object[]{e.getMessage()});
            }
            repo.setNodeFilter(this.filter);
        }
        this.getRepositoryManager().saveRepository(repo);
        this.ci.println((Object)"repository added");
    }
}

