/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.common.console;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.common.console.CommandUtil;
import org.eclipse.gyrex.common.console.SubCommand;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public abstract class BaseCommandProvider
implements CommandProvider {
    private final TreeMap<String, Class<? extends Command>> commands = new TreeMap();
    protected boolean printStackTraces = false;

    protected final void execute(CommandInterpreter ci) {
        String command = ci.nextArgument();
        if (StringUtils.isBlank((String)command)) {
            ci.println((Object)"ERROR: Missing command name!");
            ci.println((Object)this.getHelp());
            return;
        }
        if (CommandUtil.isHelpOption(command)) {
            ci.println((Object)this.getHelp());
            return;
        }
        Class<? extends Command> cmdClass = this.findCommandClass(command);
        if (cmdClass == null) {
            ci.println((Object)"ERROR: Command not found!");
            ci.println((Object)this.getHelp());
            return;
        }
        CommandUtil.executeCommand(ci, cmdClass, command, this.getCommandName(), this.printStackTraces);
    }

    private Class<? extends Command> findCommandClass(String command) {
        Class<? extends Command> cmdClass = this.commands.get(command);
        if (cmdClass != null) {
            return cmdClass;
        }
        for (Map.Entry<String, Class<? extends Command>> e : this.commands.entrySet()) {
            if (!e.getKey().startsWith(command)) continue;
            if (cmdClass != null) {
                return null;
            }
            cmdClass = e.getValue();
        }
        return cmdClass;
    }

    protected abstract String getCommandName();

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.append("---").append(this.getClass().getSimpleName()).appendln("---");
        String commandName = this.getCommandName();
        CommandUtil.appendCommandInfo(help, commandName, this.commands, "\t");
        return help.toString();
    }

    protected final void registerCommand(Class<? extends SubCommand> commandClass) {
        try {
            this.commands.put(commandClass.newInstance().getCommandName(), commandClass);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to register command class '%s'. %s", commandClass.getSimpleName(), e.getMessage()), e);
        }
    }

    protected final void registerCommand(String name, Class<? extends Command> commandClass) {
        this.commands.put(name, commandClass);
    }

    protected final void unregisterCommand(String name) {
        this.commands.remove(name);
    }
}

