/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.boot.internal;

import java.net.URL;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.gyrex.boot.internal.BootDebug;
import org.eclipse.gyrex.boot.internal.logback.LogbackConfigurator;
import org.eclipse.gyrex.common.runtime.BaseBundleActivator;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.server.internal.opsmode.OperationMode;
import org.eclipse.gyrex.server.internal.opsmode.OpsMode;
import org.eclipse.gyrex.server.settings.SystemSetting;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.application.ApplicationDescriptor;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootActivator
extends BaseBundleActivator {
    private static final String BUNDLE_STATE_LOCATION = ".metadata/.plugins";
    private static final Logger LOG = LoggerFactory.getLogger(BootActivator.class);
    public static final String SYMBOLIC_NAME = "org.eclipse.gyrex.boot";
    private static BootActivator sharedInstance;
    private static final AtomicReference<OpsMode> opsModeRef;
    private static final AtomicBoolean debugModeRef;
    private static final SystemSetting<Integer> portOffsetSetting;
    private static int portOffset;
    private BundleContext context;
    private ServiceTracker<PackageAdmin, PackageAdmin> bundleTracker;
    private volatile IServiceProxy<Location> instanceLocationProxy;
    private volatile IPath instanceLocationPath;
    private ServiceRegistration<?> frameworkLogServiceRegistration;

    static {
        opsModeRef = new AtomicReference();
        debugModeRef = new AtomicBoolean();
        portOffsetSetting = SystemSetting.newIntegerSetting("gyrex.portOffset", "Offset for ports opened by Gyrex in case multiple instances should be running on a single OS.").create();
    }

    public static EnvironmentInfo getEnvironmentInfo() {
        return (EnvironmentInfo)BootActivator.getInstance().getServiceHelper().trackService(EnvironmentInfo.class).getService();
    }

    public static BootActivator getInstance() {
        return sharedInstance;
    }

    public static OpsMode getOpsMode() {
        return opsModeRef.get();
    }

    public static int getPortOffset() {
        return portOffset;
    }

    public static boolean isDebugMode() {
        return debugModeRef.get();
    }

    public static boolean isDevMode() {
        OpsMode mode = BootActivator.getOpsMode();
        if (mode == null) {
            return true;
        }
        return mode.getMode() != OperationMode.PRODUCTION;
    }

    public BootActivator() {
        super(SYMBOLIC_NAME);
    }

    protected void doStart(BundleContext context) throws Exception {
        sharedInstance = this;
        this.context = context;
        this.instanceLocationProxy = this.getServiceHelper().trackService(Location.class, Location.INSTANCE_FILTER);
        OpsMode opsMode = new OpsMode();
        opsModeRef.set(opsMode);
        if (!opsMode.isSet()) {
            this.getServiceHelper().registerService(IStatus.class.getName(), (Object)new Status(2, SYMBOLIC_NAME, "The system operation mode has not been configured yet. Therefore the system operates in development mode."), "Eclipse Gyrex", "System operation mode status information.", SYMBOLIC_NAME.concat(".status.operationMode"), null);
        }
        debugModeRef.set(context.getProperty("osgi.debug") != null || BootActivator.getOpsMode().getMode() == OperationMode.DEVELOPMENT);
        try {
            Object consoleCommands = this.getBundle().loadClass("org.eclipse.gyrex.boot.internal.console.DebugConsoleCommands").newInstance();
            this.getServiceHelper().registerService("org.eclipse.osgi.framework.console.CommandProvider", consoleCommands, "Eclipse Gyrex", "Console commands for configuring debug options at runtime", null, null);
        }
        catch (ClassNotFoundException consoleCommands) {
        }
        catch (LinkageError consoleCommands) {
        }
        catch (Exception e) {
            LOG.warn("Error while registering debug options command provider. ", (Throwable)e);
        }
        this.loggingOn();
        Integer portOffset = portOffsetSetting.get();
        if (portOffset != null) {
            if (portOffset < 0) {
                throw new IllegalStateException("Negativ port offset not allowed!");
            }
            if (portOffset > 60000) {
                throw new IllegalStateException("Setting a port offset greater than 60000 is not supported. There would be no room left to open new ports.");
            }
            BootActivator.portOffset = portOffset;
        }
    }

    protected void doStop(BundleContext context) throws Exception {
        this.loggingOff();
        sharedInstance = null;
        this.context = null;
        this.instanceLocationProxy = null;
    }

    public Bundle getBundle(String symbolicName) {
        this.getBundle().getBundleContext().getBundles();
        PackageAdmin packageAdmin = this.getBundleAdmin();
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    @Deprecated
    private PackageAdmin getBundleAdmin() {
        if (this.bundleTracker == null) {
            if (this.context == null) {
                return null;
            }
            this.bundleTracker = new ServiceTracker(this.context, PackageAdmin.class, null);
            this.bundleTracker.open();
        }
        return (PackageAdmin)this.bundleTracker.getService();
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected Class<?> getDebugOptions() {
        return BootDebug.class;
    }

    public ApplicationDescriptor getEclipseApplication(String applicationId) throws IllegalStateException {
        Collection serviceReferences;
        String filterString = NLS.bind((String)"(&(objectClass={0})(service.pid={1})(application.container=org.eclipse.equinox.app)(eclipse.application.type=any.thread))", (Object)ApplicationDescriptor.class.getName(), (Object)applicationId);
        try {
            serviceReferences = this.context.getServiceReferences(ApplicationDescriptor.class, filterString);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(NLS.bind((String)"Internal error while looking for application {0} using filer {1}. {2}", (Object[])new Object[]{applicationId, filterString, e.getMessage()}));
        }
        if (serviceReferences == null || serviceReferences.isEmpty()) {
            throw new IllegalStateException(NLS.bind((String)"Application {0} not found!", (Object)applicationId));
        }
        if (serviceReferences.size() > 1) {
            throw new IllegalStateException(NLS.bind((String)"Multiple applications with id {0} found! Just one expected!", (Object)applicationId));
        }
        ServiceReference serviceReference = (ServiceReference)serviceReferences.iterator().next();
        try {
            ApplicationDescriptor applicationDescriptor = (ApplicationDescriptor)this.context.getService(serviceReference);
            return applicationDescriptor;
        }
        finally {
            this.context.ungetService(serviceReference);
        }
    }

    public FrameworkLog getFrameworkLog() {
        try {
            return (FrameworkLog)this.getServiceHelper().trackService(FrameworkLog.class).getService();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public Location getInstanceLocation() throws IllegalStateException {
        IServiceProxy<Location> proxy = this.instanceLocationProxy;
        if (proxy == null) {
            throw this.createBundleInactiveException();
        }
        return (Location)proxy.getService();
    }

    public IPath getInstanceLocationPath() {
        if (this.instanceLocationPath != null) {
            return this.instanceLocationPath;
        }
        URL url = this.getInstanceLocation().getURL();
        if (url == null) {
            throw new IllegalStateException("instance location not available");
        }
        if (!url.getProtocol().equals("file")) {
            throw new IllegalStateException("instance location must be on local file system");
        }
        this.instanceLocationPath = new Path(url.getPath());
        return this.instanceLocationPath;
    }

    public IPath getStateLocation(Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must not be null");
        }
        return this.getInstanceLocationPath().append(BUNDLE_STATE_LOCATION).append(bundle.getSymbolicName());
    }

    private void loggingOff() {
        if (this.frameworkLogServiceRegistration != null) {
            this.frameworkLogServiceRegistration.unregister();
            this.frameworkLogServiceRegistration = null;
        }
        try {
            LogbackConfigurator.reset();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (Exception e) {
            LOG.warn("Error while de-configuring logback. Please re-configure logging manually. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            System.err.printf("Error while de-configuring logback. Please re-configure logging manually. %s", ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private void loggingOn() {
        try {
            LogbackConfigurator.configureDefaultContext();
            LogbackConfigurator.initializeLogLevelOverrides();
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Logback not available. Please configure logging manually. ({})", (Object)e.getMessage());
        }
        catch (LinkageError e) {
            LOG.debug("Logback not available. Please configure logging manually. ({})", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOG.warn("Error while configuring logback. Please configure logging manually. {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object)e);
            System.err.printf("Error while configuring logback. Please configure logging manually. %s", ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        this.frameworkLogServiceRegistration = BootActivator.getInstance().getServiceHelper().registerService(Logger.class.getName(), (Object)LoggerFactory.getLogger((String)"org.eclipse.equinox.logger"), "Eclipse Gyrex", "SLF4J Equinox Framework Logger", "org.slf4j.Logger-org.eclipse.equinox.logger", null);
    }
}

