/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.log.wildfire;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.gyrex.http.log.internal.WildfireAppender;

public class WidlfireLogWriterFilter
implements Filter {
    public static final String ATTR_NAME_LOGGING_ENABLED = "org.eclipse.gyrex.http.log.wildfire.enabled";
    private final AtomicBoolean sessionSpecificLogging = new AtomicBoolean();

    public static void disableLogging(HttpSession session) {
        session.removeAttribute(ATTR_NAME_LOGGING_ENABLED);
    }

    public static void enableLogging(HttpSession session) {
        session.setAttribute(ATTR_NAME_LOGGING_ENABLED, (Object)Boolean.TRUE);
    }

    public void destroy() {
    }

    public void disableSessionSpecificLogging() {
        this.sessionSpecificLogging.set(false);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            HttpSession session = httpServletRequest.getSession(false);
            if (!this.sessionSpecificLogging.get() || session != null && Boolean.TRUE.equals(session.getAttribute(ATTR_NAME_LOGGING_ENABLED))) {
                WildfireAppender.setResponse((HttpServletResponse)response);
            }
            chain.doFilter(request, response);
        }
        finally {
            WildfireAppender.setResponse(null);
        }
    }

    public void enableSessionSpecificLogging() {
        this.sessionSpecificLogging.set(true);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

