/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.internal;

import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.core.spi.scanning.ScannerException;
import com.sun.jersey.core.spi.scanning.ScannerListener;
import com.sun.jersey.spi.container.ReloadListener;
import com.sun.jersey.spi.scanning.PathProviderScannerListener;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.eclipse.gyrex.http.jaxrs.internal.BundleScanner;
import org.eclipse.gyrex.http.jaxrs.internal.JaxRsDebug;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleScanningResourceConfig
extends DefaultResourceConfig
implements ReloadListener {
    private static final Logger LOG = LoggerFactory.getLogger(BundleScanningResourceConfig.class);
    private final Bundle bundle;

    public BundleScanningResourceConfig(Bundle bundle) {
        this.bundle = bundle;
        this.scan();
    }

    public void onReload() {
        this.getClasses().clear();
        this.scan();
    }

    private void scan() {
        BundleWiring bundleWiring;
        if (JaxRsDebug.resourceDiscovery) {
            LOG.debug("Scanning bundle '{}' for annotated classes.", (Object)this.bundle);
        }
        if ((bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class)) == null) {
            throw new ScannerException(String.format("No wiring available for bundle '%s'", this.bundle));
        }
        ClassLoader loader = bundleWiring.getClassLoader();
        if (loader == null) {
            throw new ScannerException(String.format("No class loader available for bundle '%s'", this.bundle));
        }
        PathProviderScannerListener scannerListener = new PathProviderScannerListener(loader);
        new BundleScanner(this.bundle, bundleWiring, loader).scan((ScannerListener)scannerListener);
        Set annotatedClasses = scannerListener.getAnnotatedClasses();
        if (annotatedClasses.isEmpty()) {
            LOG.warn("No JAX-RS annotated classed found in bundle '{}'.", (Object)this.bundle);
        } else {
            for (Class annotatedClass : annotatedClasses) {
                if (JaxRsDebug.resourceDiscovery) {
                    if (annotatedClass.isAnnotationPresent(Path.class)) {
                        LOG.debug("Found resource: {}", (Object)annotatedClass.getName());
                    } else if (annotatedClass.isAnnotationPresent(Provider.class)) {
                        LOG.debug("Found provider: {}", (Object)annotatedClass.getName());
                    }
                }
                this.getClasses().add(annotatedClass);
            }
        }
    }
}

