/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.jaxrs.jersey.spi.inject;

import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.eclipse.gyrex.common.services.BundleServiceHelper;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceInjectableProvider<A extends Annotation>
implements InjectableProvider<A, Type> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseServiceInjectableProvider.class);
    private final BundleContext bundleContext;
    private final BundleServiceHelper serviceHelper;

    public BaseServiceInjectableProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.serviceHelper = new BundleServiceHelper(bundleContext);
    }

    public void dispose() {
        this.serviceHelper.dispose();
    }

    private Class<?> getClass(Type type) {
        block4: {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                try {
                    return (Class)((ParameterizedType)type).getRawType();
                }
                catch (Exception ignored) {
                    if (!LOG.isDebugEnabled()) break block4;
                    LOG.debug("Unable to cast raw type of ParameterizedType ({}) to Class.", (Object)type, (Object)ignored);
                }
            }
        }
        return null;
    }

    private Class<?> getCollectionElementType(Type type) {
        Type[] typeArguments;
        if (type instanceof ParameterizedType && (typeArguments = ((ParameterizedType)type).getActualTypeArguments()).length == 1) {
            return this.getClass(typeArguments[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unable to detect collection element type for ({}).", (Object)type);
        }
        return null;
    }

    public Injectable getInjectable(ComponentContext componentContext, A contextAnnotation, Type requestedType) {
        Class<?> clazz = this.getClass(requestedType);
        if (clazz == null) {
            return null;
        }
        boolean collectionOfServices = Collection.class.isAssignableFrom(clazz) || List.class.isAssignableFrom(clazz);
        Class<?> serviceInterface = collectionOfServices ? this.getCollectionElementType(requestedType) : clazz;
        ServiceReference sr = this.bundleContext.getServiceReference(serviceInterface.getName());
        if (sr == null) {
            return null;
        }
        final IServiceProxy serviceProxy = this.serviceHelper.trackService(serviceInterface);
        return new Injectable<Object>(){

            public Object getValue() {
                return serviceProxy.getProxy();
            }
        };
    }

    public ComponentScope getScope() {
        return ComponentScope.PerRequest;
    }
}

