/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.p2.internal.commands;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.services.locking.ILockService;
import org.eclipse.gyrex.common.console.Command;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallState;
import org.eclipse.gyrex.p2.internal.installer.PackageInstallerJob;
import org.osgi.service.prefs.BackingStoreException;

public final class StatusCmd
extends Command {
    public StatusCmd() {
        super("prints status information about the sw process");
    }

    protected void doExecute() throws Exception {
        String activeSessionId;
        block13: {
            IProvisioningAgent agent = null;
            try {
                try {
                    agent = ((IProvisioningAgentProvider)P2Activator.getInstance().getService(IProvisioningAgentProvider.class)).createAgent(null);
                    if (agent == null) {
                        throw new IllegalStateException("The current system has not been provisioned using p2. Unable to acquire provisioning agent.");
                    }
                    this.printInstalledPackages(agent);
                }
                catch (Exception e) {
                    this.printf("Unable to determine packages installed on node %s. %s", new Object[]{this.getNodeId(), e.getMessage()});
                    if (agent != null) {
                        agent.stop();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                if (agent != null) {
                    agent.stop();
                }
                throw throwable;
            }
            if (agent != null) {
                agent.stop();
            }
        }
        if (StringUtils.isNotBlank((String)(activeSessionId = PackageInstallState.getActiveInstallSessionId()))) {
            this.printf("Active installation on %s (%s)!", new Object[]{this.getNodeId(), activeSessionId});
        } else {
            this.printf("No installation active on %s!", new Object[]{this.getNodeId()});
        }
        ILockService lockService = (ILockService)P2Activator.getInstance().getService(ILockService.class);
        IStatus lockStatus = lockService.getDurableLockStatus(PackageInstallerJob.ID_INSTALL_LOCK);
        this.printf("Installation lock: %s", new Object[]{lockStatus.getMessage()});
        if (lockStatus.isMultiStatus()) {
            IStatus[] iStatusArray = lockStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus status = iStatusArray[n2];
                this.printf("   %s", new Object[]{status.getMessage()});
                ++n2;
            }
        }
    }

    private String getNodeId() {
        try {
            return ((INodeEnvironment)P2Activator.getInstance().getService(INodeEnvironment.class)).getNodeId();
        }
        catch (IllegalStateException e) {
            return "this node";
        }
    }

    public void printInstalledPackages(IProvisioningAgent agent) throws BackingStoreException {
        IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
        if (profileRegistry == null) {
            throw new IllegalStateException("The current system has not been provisioned using p2. Unable to acquire profile registry.");
        }
        IProfile profile = profileRegistry.getProfile("_SELF_");
        if (profile == null) {
            throw new IllegalStateException("The current system has not been provisioned using p2. Unable to get profile.");
        }
        IQueryResult result = profile.available(QueryUtil.createIUPropertyQuery((String)"org.eclipse.gyrex.p2.package", (String)Boolean.TRUE.toString()), null);
        if (result.isEmpty()) {
            this.printf("No packages installed on %s.", new Object[]{this.getNodeId()});
            return;
        }
        this.printf("The following packages are available on this node:", new Object[0]);
        Object[] packageIUs = (IInstallableUnit[])result.toArray(IInstallableUnit.class);
        Arrays.sort(packageIUs);
        Object[] objectArray = packageIUs;
        int n = packageIUs.length;
        int n2 = 0;
        while (n2 < n) {
            Object unit = objectArray[n2];
            this.printf("   %s, %s", new Object[]{PackageInstallState.getPackageId((IInstallableUnit)unit), unit.getVersion()});
            ++n2;
        }
    }
}

