/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.mongodb.internal.jpa;

import com.mongodb.DB;
import com.mongodb.Mongo;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.common.internal.services.IServiceProxyChangeListener;
import org.eclipse.gyrex.common.internal.services.ServiceProxy;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.common.services.ServiceNotAvailableException;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.persistence.eclipselink.EclipseLinkRepository;
import org.eclipse.gyrex.persistence.mongodb.internal.MongoDbActivator;
import org.eclipse.gyrex.persistence.mongodb.internal.MongoDbRegistry;
import org.eclipse.gyrex.persistence.mongodb.internal.jpa.MongoDbJpaRepositoryMetrics;
import org.eclipse.gyrex.persistence.storage.content.RepositoryContentType;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.gyrex.persistence.storage.settings.IRepositoryPreferences;
import org.osgi.service.jpa.EntityManagerFactoryBuilder;

public class MongoDbJpaRepositoryImpl
extends EclipseLinkRepository {
    private final IRepositoryPreferences repositoryPreferences;
    private final ConcurrentMap<RepositoryContentType, WeakReference<EntityManagerFactory>> emfCacheByContentType = new ConcurrentHashMap<RepositoryContentType, WeakReference<EntityManagerFactory>>();
    private final String databaseName;
    private final String poolId;

    public MongoDbJpaRepositoryImpl(String repositoryId, RepositoryProvider repositoryProvider, IRepositoryPreferences repositoryPreferences) {
        super(repositoryId, repositoryProvider, (MetricSet)new MongoDbJpaRepositoryMetrics(MongoDbJpaRepositoryImpl.createMetricsId((RepositoryProvider)repositoryProvider, (String)repositoryId), repositoryId, repositoryProvider, "new", "created"));
        this.repositoryPreferences = repositoryPreferences;
        this.databaseName = repositoryPreferences.get("db", null);
        this.poolId = repositoryPreferences.get("poolId", null);
    }

    protected EntityManagerFactory createEntityManagerFactory(RepositoryContentType contentType) {
        EntityManagerFactoryBuilder builder;
        IServiceProxy builderServiceProxy;
        if (!StringUtils.equals((String)EclipseLinkRepository.class.getName(), (String)contentType.getRepositoryTypeName())) {
            throw new IllegalArgumentException(String.format("Incompatible content type specified. EclipseLink Repository type expected but the specified type expects %s.", contentType.getRepositoryTypeName()));
        }
        String unitName = contentType.getParameter("persistenceUnitName");
        if (unitName == null) {
            unitName = contentType.getMediaTypeSubType();
        }
        try {
            builderServiceProxy = MongoDbActivator.getInstance().getServiceHelper().trackService(EntityManagerFactoryBuilder.class, String.format("(&(objectClass=%s)(%s=%s))", EntityManagerFactoryBuilder.class.getName(), "osgi.unit.name", unitName));
            builder = (EntityManagerFactoryBuilder)builderServiceProxy.getService();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid content type specified. The persistence unit name (%s) is invalid. %s", unitName, e.getMessage()), e);
        }
        catch (ServiceNotAvailableException e) {
            throw new IllegalStateException(String.format("No EntityManagerFactoryBuilder service available for content type (%s).", contentType), e);
        }
        if (this.poolId == null) {
            throw new IllegalStateException(String.format("No pool configured for repository '%s'.", this.getRepositoryId()));
        }
        if (this.databaseName == null) {
            throw new IllegalStateException(String.format("No database name configured for repository '%s'.", this.getRepositoryId()));
        }
        MongoDbRegistry registry = MongoDbActivator.getInstance().getRegistry();
        Mongo mongo = registry.get(this.poolId);
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            DB db = mongo.getDB(this.databaseName);
            props.put("javax.persistence.transactionType", "RESOURCE_LOCAL");
            props.put("eclipselink.target-database", "org.eclipse.persistence.nosql.adapters.mongo.MongoPlatform");
            props.put("eclipselink.nosql.connection-spec", "org.eclipse.persistence.nosql.adapters.mongo.MongoConnectionSpec");
            props.put("eclipselink.nosql.property.mongo.db", this.databaseName);
            props.put("javax.persistence.nonJtaDataSource", "");
            props.put("eclipselink.session-name", this.getRepositoryId());
            EntityManagerFactory entityManagerFactory = builder.createEntityManagerFactory(props);
            EMFDisposer emfDisposer = new EMFDisposer(entityManagerFactory, contentType);
            ((ServiceProxy)builderServiceProxy).addChangeListener((IServiceProxyChangeListener)emfDisposer, (Object)builder);
            return entityManagerFactory;
        }
        catch (Exception e) {
            registry.unget(this.poolId);
            throw new IllegalStateException(String.format("Unable to create EntityManagerFactory for persistence unit name (%s) repository (%s). %s", unitName, this.getRepositoryId(), e.getMessage()), e);
        }
    }

    protected void doClose() {
        MongoDbActivator.getInstance().getRegistry().unget(this.poolId);
        ((MongoDbJpaRepositoryMetrics)this.getMetrics()).setClosed("stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getEntityManagerFactory(RepositoryContentType contentType) {
        EntityManagerFactory factory;
        WeakReference factoryRef = (WeakReference)this.emfCacheByContentType.get(contentType);
        EntityManagerFactory entityManagerFactory = factory = factoryRef != null ? (EntityManagerFactory)factoryRef.get() : null;
        if (factory == null || !factory.isOpen()) {
            ConcurrentMap<RepositoryContentType, WeakReference<EntityManagerFactory>> concurrentMap = this.emfCacheByContentType;
            synchronized (concurrentMap) {
                factoryRef = (WeakReference)this.emfCacheByContentType.get(contentType);
                EntityManagerFactory entityManagerFactory2 = factory = factoryRef != null ? (EntityManagerFactory)factoryRef.get() : null;
                if (factory == null || !factory.isOpen()) {
                    factory = this.createEntityManagerFactory(contentType);
                    this.emfCacheByContentType.put(contentType, new WeakReference<EntityManagerFactory>(factory));
                }
            }
        }
        return factory;
    }

    private class EMFDisposer
    implements IServiceProxyChangeListener {
        private final WeakReference<EntityManagerFactory> entityManagerFactory;
        private final RepositoryContentType contentType;

        public EMFDisposer(EntityManagerFactory entityManagerFactory, RepositoryContentType contentType) {
            this.contentType = contentType;
            this.entityManagerFactory = new WeakReference<EntityManagerFactory>(entityManagerFactory);
        }

        public boolean serviceChanged(IServiceProxy<?> proxy) {
            MongoDbJpaRepositoryImpl.this.emfCacheByContentType.remove(this.contentType);
            EntityManagerFactory factory = (EntityManagerFactory)this.entityManagerFactory.get();
            if (factory != null && factory.isOpen()) {
                try {
                    factory.close();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

