/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.internal;

import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.gyrex.eventbus.IEventHandler;

public abstract class EventHandler {
    public static EventHandler of(Class<?> eventType, IEventHandler<Object> eventHandler) {
        return new WrappedEventHandler(eventType, eventHandler);
    }

    public static EventHandler of(Class<?> eventType, Method method, Object object) {
        return new EventHandlerMethod(method, eventType, object);
    }

    public abstract Class<?> getEventType();

    public abstract void handleEvent(Object var1);

    static final class EventHandlerMethod
    extends EventHandler {
        private final Method method;
        private final Class<?> eventType;
        private final Object object;

        EventHandlerMethod(Method method, Class<?> eventType, Object object) {
            this.method = method;
            this.eventType = eventType;
            this.object = object;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                EventHandlerMethod other = (EventHandlerMethod)obj;
                return Objects.equal(this.eventType, other.eventType) && Objects.equal((Object)this.method, (Object)other.method) && Objects.equal((Object)this.object, (Object)other.object);
            }
            return false;
        }

        @Override
        public Class<?> getEventType() {
            return this.eventType;
        }

        @Override
        public void handleEvent(Object event) {
            try {
                this.method.invoke(this.object, event);
            }
            catch (InvocationTargetException e) {
                Throwables.propagate((Throwable)e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(String.format("Event handler method (%s) on object (%s) not accessible!", this.method, this.object), e);
            }
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.eventType, this.method, this.object});
        }

        public String toString() {
            return Objects.toStringHelper((String)"EventHandlerMethod").add("type", this.eventType).add("method", (Object)this.method).add("object", this.object).toString();
        }
    }

    static final class WrappedEventHandler
    extends EventHandler {
        private final IEventHandler<Object> eventHandler;
        private final Class<?> eventType;

        WrappedEventHandler(Class<?> eventType, IEventHandler<Object> eventHandler) {
            this.eventType = eventType;
            this.eventHandler = eventHandler;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() == this.getClass()) {
                WrappedEventHandler other = (WrappedEventHandler)obj;
                return Objects.equal(this.eventType, other.eventType) && Objects.equal(this.eventHandler, other.eventHandler);
            }
            return false;
        }

        @Override
        public Class<?> getEventType() {
            return this.eventType;
        }

        @Override
        public void handleEvent(Object event) {
            this.eventHandler.handleEvent(event);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.eventType, this.eventHandler});
        }

        public String toString() {
            return Objects.toStringHelper((String)"WrappedEventHandler").add("type", this.eventType).add("handler", this.eventHandler).toString();
        }
    }
}

