/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.internal;

import com.google.common.base.Preconditions;
import org.eclipse.gyrex.cloud.environment.INodeEnvironment;
import org.eclipse.gyrex.cloud.services.events.IEventTransport;
import org.eclipse.gyrex.common.services.BundleServiceHelper;
import org.eclipse.gyrex.common.services.IServiceProxy;
import org.eclipse.gyrex.eventbus.IEventBus;
import org.eclipse.gyrex.eventbus.ITopicBuilder;
import org.eclipse.gyrex.eventbus.internal.EventService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServiceComponent
implements IEventBus {
    private static final Logger LOG = LoggerFactory.getLogger(EventServiceComponent.class);
    private volatile EventService eventService;
    private BundleServiceHelper serviceHelper;

    public void activate(ComponentContext context) {
        LOG.debug("Activating event bus ({})", (Object)this);
        Preconditions.checkState((this.serviceHelper == null ? 1 : 0) != 0, (Object)"duplicate activation");
        this.serviceHelper = new BundleServiceHelper(context.getBundleContext());
        String nodeId = ((INodeEnvironment)this.serviceHelper.trackService(INodeEnvironment.class).getService()).getNodeId();
        this.eventService = new EventService(nodeId, (IServiceProxy<IEventTransport>)this.serviceHelper.trackService(IEventTransport.class));
    }

    public void deactivate(ComponentContext context) {
        LOG.debug("Deactivating event bus ({})", (Object)this);
        if (this.eventService != null) {
            this.eventService.dispose();
            this.eventService = null;
        }
        if (this.serviceHelper != null) {
            this.serviceHelper.dispose();
            this.serviceHelper = null;
        }
    }

    private EventService getEventService() {
        EventService service = this.eventService;
        Preconditions.checkState((service != null ? 1 : 0) != 0, (Object)"inactive");
        return service;
    }

    @Override
    public ITopicBuilder getTopic(String id) throws IllegalArgumentException, IllegalStateException {
        return this.getEventService().getTopic(id);
    }
}

