/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.eventbus.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Parameter;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.eventbus.IEventDeserializer;
import org.eclipse.gyrex.eventbus.IEventSerializer;
import org.eclipse.gyrex.eventbus.ITopicBuilder;
import org.eclipse.gyrex.eventbus.internal.EventService;
import org.eclipse.gyrex.eventbus.internal.Topic;

public class TopicBuilder
implements ITopicBuilder {
    @VisibleForTesting
    final String id;
    @VisibleForTesting
    final Map<Class<?>, IEventSerializer<Object>> serializers = new HashMap();
    @VisibleForTesting
    final Map<Class<?>, IEventDeserializer<Object>> deserializers = new HashMap();
    @VisibleForTesting
    final Map<String, Object> properties = new HashMap<String, Object>();
    private final EventService eventService;

    TopicBuilder(String id, EventService eventService) {
        this.eventService = eventService;
        Preconditions.checkArgument((boolean)IdHelper.isValidId((String)id), (Object)"invalid id");
        this.id = id;
    }

    @Override
    public TopicBuilder addDeserializer(IEventDeserializer<?> ... deserializers) {
        Preconditions.checkArgument((deserializers != null && deserializers.length > 0 ? 1 : 0) != 0, (Object)"no deserializer specified");
        IEventDeserializer<?>[] iEventDeserializerArray = deserializers;
        int n = deserializers.length;
        int n2 = 0;
        while (n2 < n) {
            IEventDeserializer<?> deserializer = iEventDeserializerArray[n2];
            this.addDeserializerInternal(deserializer);
            ++n2;
        }
        return this;
    }

    @VisibleForTesting
    void addDeserializerInternal(IEventDeserializer<?> deserializer) {
        Method[] methods;
        Preconditions.checkArgument((deserializer != null ? 1 : 0) != 0, (Object)"null deserializer not allowed");
        Method[] methodArray = methods = deserializer.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Invokable invokable;
            Class eventType;
            Method method = methodArray[n2];
            if (method.getName().equals("deserializeEvent") && method.getParameterTypes().length == 1 && this.isAllowedEventType(eventType = (invokable = Invokable.from((Method)method)).getReturnType().getRawType()) && this.isByteArray((TypeToken<? extends Object>)((Parameter)invokable.getParameters().get(0)).getType())) {
                Preconditions.checkArgument((!this.deserializers.containsKey(eventType) ? 1 : 0) != 0, (String)"duplicate deserializer for type '%s'", (Object[])new Object[]{eventType});
                this.deserializers.put(eventType, deserializer);
            }
            ++n2;
        }
    }

    @Override
    public TopicBuilder addSerializer(IEventSerializer<?> ... serializers) {
        Preconditions.checkArgument((serializers != null && serializers.length > 0 ? 1 : 0) != 0, (Object)"no serializer specified");
        IEventSerializer<?>[] iEventSerializerArray = serializers;
        int n = serializers.length;
        int n2 = 0;
        while (n2 < n) {
            IEventSerializer<?> serializer = iEventSerializerArray[n2];
            this.addSerializerInternal(serializer);
            ++n2;
        }
        return this;
    }

    @VisibleForTesting
    void addSerializerInternal(IEventSerializer<?> serializer) {
        Method[] methods;
        Preconditions.checkArgument((serializer != null ? 1 : 0) != 0, (Object)"null serializer not allowed");
        Method[] methodArray = methods = serializer.getClass().getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Invokable invokable;
            Class eventType;
            Method method = methodArray[n2];
            if (method.getName().equals("serializeEvent") && method.getParameterTypes().length == 1 && this.isAllowedEventType(eventType = ((Parameter)(invokable = Invokable.from((Method)method)).getParameters().get(0)).getType().getRawType()) && this.isByteArray((TypeToken<? extends Object>)invokable.getReturnType())) {
                Preconditions.checkArgument((!this.serializers.containsKey(eventType) ? 1 : 0) != 0, (String)"duplicate serializer for type '%s'", (Object[])new Object[]{eventType});
                this.serializers.put(eventType, serializer);
            }
            ++n2;
        }
    }

    @Override
    public Topic build() throws IllegalArgumentException, IllegalStateException, SecurityException {
        return new Topic(this.id, this.properties, this.serializers, this.deserializers, this.getEventService());
    }

    EventService getEventService() {
        return this.eventService;
    }

    public String getId() {
        return this.id;
    }

    private boolean isAllowedEventType(Class<?> eventType) {
        return this.getEventService().getReflectionService().isAllowedEventType(eventType);
    }

    private boolean isByteArray(TypeToken<? extends Object> returnType) {
        return returnType.isArray() && returnType.getComponentType().isPrimitive() && returnType.getComponentType().getRawType().equals(Byte.TYPE);
    }

    @Override
    public TopicBuilder setProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }
}

