/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.application;

import java.util.Collections;
import java.util.List;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.application.DropDownNavigation;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.AdminPageRegistry;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.CategoryContribution;
import org.eclipse.gyrex.admin.ui.internal.pages.registry.PageContribution;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class NavigationBar
extends Composite {
    private static final long serialVersionUID = 1L;
    private final List<CategoryContribution> categories;

    public NavigationBar(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)AdminUiUtil.createGridLayoutWithoutMargin(5, false));
        this.setData("org.eclipse.rap.rwt.customVariant", "navigation");
        this.categories = AdminPageRegistry.getInstance().getCategories();
        Collections.sort(this.categories);
        for (CategoryContribution category : this.categories) {
            this.createNavigationDropDown(category);
        }
    }

    private void changeSelectedDropDownEntry(PageContribution page, DropDownNavigation navEntry) {
        navEntry.setSelected(this.pageBelongsToDropDownNav(page, navEntry));
    }

    private void createNavigationDropDown(CategoryContribution category) {
        new DropDownNavigation(this, category){
            private static final long serialVersionUID = 1L;

            @Override
            protected void openPage(PageContribution page) {
                NavigationBar.this.openPage(page);
            }
        };
    }

    public PageContribution findInitialPage() {
        Control[] children;
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                return ((DropDownNavigation)control).findFirstPage();
            }
            ++n2;
        }
        return null;
    }

    protected abstract void openPage(PageContribution var1);

    private boolean pageBelongsToDropDownNav(PageContribution page, DropDownNavigation navEntry) {
        CategoryContribution category = navEntry.getCategory();
        return category.getId().equals(page.getCategoryId());
    }

    public void selectNavigationEntry(PageContribution page) {
        Control[] children;
        Control[] controlArray = children = this.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof DropDownNavigation) {
                this.changeSelectedDropDownEntry(page, (DropDownNavigation)control);
            }
            ++n2;
        }
    }
}

