/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.internal.pages.registry;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.gyrex.admin.ui.pages.AdminPage;

public class PageContribution
implements Comparable<PageContribution> {
    private final IConfigurationElement element;
    private final String id;
    private String[] keywords;

    public PageContribution(IConfigurationElement element) {
        this.element = element;
        this.id = element.getAttribute("id");
        if (StringUtils.isBlank((String)this.id)) {
            throw new IllegalArgumentException("id is required");
        }
    }

    @Override
    public int compareTo(PageContribution o) {
        return this.getSortKey().compareTo(o.getSortKey());
    }

    public AdminPage createPage() throws CoreException {
        return (AdminPage)this.element.createExecutableExtension("class");
    }

    public boolean equals(Object provider) {
        return provider instanceof PageContribution ? this.getId().equals(((PageContribution)provider).getId()) : Boolean.FALSE.booleanValue();
    }

    public String getCategoryId() {
        return this.element.getAttribute("categoryId");
    }

    public String getId() {
        return this.id;
    }

    public String[] getKeywords() {
        if (this.keywords == null) {
            this.keywords = StringUtils.split((String)this.element.getAttribute("keywords"));
            if (this.keywords == null) {
                this.keywords = new String[0];
            }
        }
        return this.keywords;
    }

    public String getName() {
        String name = this.element.getAttribute("name");
        return name != null ? name : this.getId();
    }

    public String getSortKey() {
        String value = this.element.getAttribute("sortKey");
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        value = this.getName();
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        return this.getId();
    }
}

