/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.schedules;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gyrex.cloud.services.queue.IQueue;
import org.eclipse.gyrex.cloud.services.queue.IQueueService;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.JobsActivator;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.manager.JobManagerImpl;
import org.eclipse.gyrex.jobs.internal.scheduler.SchedulingJob;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleEntryImpl;
import org.eclipse.gyrex.jobs.internal.schedules.ScheduleImpl;
import org.eclipse.gyrex.jobs.manager.IJobManager;
import org.eclipse.gyrex.jobs.schedules.IScheduleEntry;

public class SchedulingUtil {
    public static String createScheduleInfo(String scheduleId, String scheduleEntryId, String scheduleEntriesToTriggerAfterRun) {
        if (StringUtils.isBlank((String)scheduleEntriesToTriggerAfterRun)) {
            return String.valueOf(scheduleId) + ',' + scheduleEntryId;
        }
        return String.valueOf(scheduleId) + ',' + scheduleEntryId + ',' + scheduleEntriesToTriggerAfterRun;
    }

    public static String getScheduleEntriesToTriggerAfterRun(IScheduleEntry entry, ScheduleImpl schedule) {
        return StringUtils.join(schedule.getEntriesToTriggerAfter(entry.getId()), (char)',');
    }

    public static void queueJob(ScheduleEntryImpl entry) {
        IPath contextPath = entry.getSchedule().getContextPath();
        String scheduleId = entry.getSchedule().getId();
        String scheduleEntryId = entry.getId();
        String scheduleEntriesToTriggerAfterRun = SchedulingUtil.getScheduleEntriesToTriggerAfterRun(entry, entry.getSchedule());
        String queueId = StringUtils.isNotBlank((String)entry.getQueueId()) ? entry.getQueueId() : entry.getSchedule().getQueueId();
        String jobId = entry.getJobId();
        String jobTypeId = entry.getJobTypeId();
        Map<String, String> jobParameter = entry.getJobParameter();
        SchedulingUtil.queueJob(jobId, jobTypeId, contextPath, scheduleId, scheduleEntryId, scheduleEntriesToTriggerAfterRun, queueId, jobParameter);
    }

    public static void queueJob(String jobId, String jobTypeId, IPath contextPath, String scheduleId, String scheduleEntryId, String scheduleEntriesToTriggerAfterRun, String queueId, Map<String, String> parameter) {
        IRuntimeContext runtimeContext = ((IRuntimeContextRegistry)JobsActivator.getInstance().getService(IRuntimeContextRegistry.class)).get(contextPath);
        if (runtimeContext == null) {
            SchedulingJob.LOG.error("Unable to find context (using path {}) for job {}.", (Object)contextPath, (Object)jobId);
            return;
        }
        IJobManager jobManager = (IJobManager)runtimeContext.get(IJobManager.class);
        if (!(jobManager instanceof JobManagerImpl)) {
            SchedulingJob.LOG.error("Invalid job manager ({}). Please verify the system is setup properly.", (Object)jobManager);
            return;
        }
        JobManagerImpl jobManagerImpl = (JobManagerImpl)jobManager;
        JobImpl job = jobManagerImpl.getJob(jobId);
        if (job != null && job.getState() != JobState.NONE && !jobManagerImpl.isStuck(job)) {
            SchedulingJob.LOG.warn("Job {} (type {}) cannot be queued because it is already active in the system (current state {}).", new Object[]{job.getId(), job.getTypeId(), job.getState()});
            return;
        }
        IQueueService queueService = JobsActivator.getInstance().getQueueService();
        IQueue queue = queueService.getQueue(queueId != null ? queueId : "gyrex.jobs.queue.default", null);
        if (queue == null) {
            queue = queueService.createQueue(queueId != null ? queueId : "gyrex.jobs.queue.default", null);
        }
        jobManagerImpl.queueJob(jobTypeId, jobId, parameter, queue.getId(), String.format("Schedule '%s' entry '%s'.", scheduleId, scheduleEntryId), SchedulingUtil.createScheduleInfo(scheduleId, scheduleEntryId, scheduleEntriesToTriggerAfterRun));
    }

    private SchedulingUtil() {
    }
}

