/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.jobs.JobState;
import org.eclipse.gyrex.jobs.internal.manager.JobImpl;
import org.eclipse.gyrex.jobs.internal.storage.CloudPreferencesCleanupJobProvider;
import org.eclipse.gyrex.jobs.internal.util.ContextHashUtil;
import org.eclipse.gyrex.preferences.CloudScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CloudPreferncesJobStorage {
    public static final String NODE_PARAMETER = "parameter";
    static final String NODE_STATES = "status";
    public static final String PROPERTY_TYPE = "type";
    public static final String PROPERTY_STATUS = "status";
    public static final String PROPERTY_LAST_START = "lastStart";
    public static final String PROPERTY_LAST_QUEUED = "lastQueued";
    public static final String PROPERTY_LAST_QUEUED_TRIGGER = "lastQueuedTrigger";
    public static final String PROPERTY_LAST_CANCELLED = "lastCancelled";
    public static final String PROPERTY_LAST_CANCELLED_TRIGGER = "lastCancelledTrigger";
    public static final String PROPERTY_LAST_SUCCESSFUL_START = "lastSuccessfulStart";
    public static final String PROPERTY_LAST_SUCCESSFUL_FINISH = "lastSuccessfulFinish";
    public static final String PROPERTY_LAST_RESULT_MESSAGE = "lastResultMessage";
    public static final String PROPERTY_LAST_RESULT_SEVERITY = "lastResultSeverity";
    public static final String PROPERTY_LAST_RESULT = "lastResultTimestamp";
    public static final String PROPERTY_ACTIVE = "active";
    private static final String NODE_JOBS = "jobs";
    private final IRuntimeContext context;
    private final ContextHashUtil contextHash;

    public static Collection<String> getAllJobStorageKeysByState(JobState state) {
        if (state == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        try {
            String[] storageIds = CloudPreferncesJobStorage.getJobsNode().childrenNames();
            ArrayList<String> jobIds = new ArrayList<String>(storageIds.length);
            String[] stringArray = storageIds;
            int n = storageIds.length;
            int n2 = 0;
            while (n2 < n) {
                String internalId = stringArray[n2];
                if (StringUtils.equals((String)CloudPreferncesJobStorage.getJobsNode().node(internalId).get("status", null), (String)state.name())) {
                    jobIds.add(internalId);
                }
                ++n2;
            }
            return Collections.unmodifiableCollection(jobIds);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading job data. %s", e.getMessage()), e);
        }
    }

    public static IEclipsePreferences getJobsNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.jobs").node(NODE_JOBS);
    }

    public static void mayTriggerCleanup() {
        CloudPreferencesCleanupJobProvider.triggerCleanUp();
    }

    public static JobImpl readJob(String jobId, Preferences node) throws BackingStoreException {
        JobImpl job = new JobImpl(node.name());
        job.setId(jobId);
        job.setTypeId(node.get(PROPERTY_TYPE, null));
        job.setStatus(JobState.toState(node.get("status", null)));
        job.setActive(node.getBoolean(PROPERTY_ACTIVE, false));
        job.setLastStart(node.getLong(PROPERTY_LAST_START, -1L));
        job.setLastSuccessfulStart(node.getLong(PROPERTY_LAST_SUCCESSFUL_START, -1L));
        job.setLastSuccessfulFinish(node.getLong(PROPERTY_LAST_SUCCESSFUL_FINISH, -1L));
        long lastResultTimestamp = node.getLong(PROPERTY_LAST_RESULT, -1L);
        if (lastResultTimestamp > -1L) {
            job.setLastResult(lastResultTimestamp, node.getInt(PROPERTY_LAST_RESULT_SEVERITY, 8), node.get(PROPERTY_LAST_RESULT_MESSAGE, ""));
        }
        job.setLastQueued(node.getLong(PROPERTY_LAST_QUEUED, -1L));
        job.setLastQueuedTrigger(node.get(PROPERTY_LAST_QUEUED_TRIGGER, null));
        job.setLastCancelled(node.getLong(PROPERTY_LAST_CANCELLED, -1L));
        job.setLastCancelledTrigger(node.get(PROPERTY_LAST_CANCELLED_TRIGGER, null));
        HashMap<String, String> jobParamater = CloudPreferncesJobStorage.readParameter(node);
        job.setParameter(jobParamater);
        return job;
    }

    static HashMap<String, String> readParameter(Preferences node) throws BackingStoreException {
        if (!node.nodeExists(NODE_PARAMETER)) {
            return null;
        }
        Preferences paramNode = node.node(NODE_PARAMETER);
        String[] keys = paramNode.keys();
        HashMap<String, String> jobParamater = new HashMap<String, String>(keys.length);
        String[] stringArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            jobParamater.put(key, paramNode.get(key, null));
            ++n2;
        }
        return jobParamater;
    }

    @Inject
    public CloudPreferncesJobStorage(IRuntimeContext context) {
        this.context = context;
        this.contextHash = new ContextHashUtil(context);
    }

    private String toExternalId(String internalId) {
        return this.contextHash.toExternalId(internalId);
    }

    private String toInternalId(String id) {
        return this.contextHash.toInternalId(id);
    }
}

