/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleAnnotatedClassScanner {
    private static final Logger LOG = LoggerFactory.getLogger(BundleAnnotatedClassScanner.class);
    final Bundle bundle;
    final Set<Class<?>> annotatedClasses = new HashSet();
    final Set<String> annotations;
    private final ClassVisitor classVisitor = new EmptyVisitor(){
        private String currentClassName;
        private boolean hasProperVisibility;
        private boolean annotationFound;

        private boolean isPublic(int access) {
            return (access & 1) != 0;
        }

        private boolean isStatic(int access) {
            return (access & 8) == 8;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.currentClassName = name;
            this.hasProperVisibility = this.isPublic(access);
            this.annotationFound = false;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (BundleAnnotatedClassScanner.this.annotations.contains(desc)) {
                this.annotationFound = true;
            }
            return null;
        }

        public void visitEnd() {
            if (this.hasProperVisibility && this.annotationFound) {
                try {
                    BundleAnnotatedClassScanner.this.annotatedClasses.add(BundleAnnotatedClassScanner.this.bundle.loadClass(this.currentClassName.replaceAll("/", ".")));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(String.format("Unable to load class '%s' in bundle '%s'. %s", this.currentClassName, BundleAnnotatedClassScanner.this.bundle, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
                }
            }
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (StringUtils.equals((String)name, (String)this.currentClassName)) {
                this.hasProperVisibility = this.isPublic(access) && this.isStatic(access);
            }
        }
    };

    @SafeVarargs
    public BundleAnnotatedClassScanner(Bundle bundle, Class<? extends Annotation> ... annotations) {
        if (bundle == null) {
            throw new IllegalArgumentException("bundle must be provided");
        }
        if (annotations == null || annotations.length == 0) {
            throw new IllegalArgumentException("annotations must be provided");
        }
        this.bundle = bundle;
        this.annotations = new HashSet<String>();
        Class<? extends Annotation>[] classArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Annotation> annotaton = classArray[n2];
            this.annotations.add("L" + annotaton.getName().replaceAll("\\.", "/") + ";");
            ++n2;
        }
    }

    public Set<Class<?>> scan() {
        LOG.trace("Scanning bundle '{}' for annotated classes.", (Object)this.bundle);
        BundleWiring bundleWiring = (BundleWiring)this.bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            throw new IllegalStateException(String.format("No wiring available for bundle '%s'", this.bundle));
        }
        ClassLoader loader = bundleWiring.getClassLoader();
        if (loader == null) {
            throw new IllegalStateException(String.format("No class loader available for bundle '%s'", this.bundle));
        }
        Collection resources = bundleWiring.listResources("/", "*.class", 3);
        if (resources == null) {
            throw new IllegalStateException(String.format("No resources available for bundle '%s'", this.bundle));
        }
        for (String resource : resources) {
            LOG.trace("Found resource: {}", (Object)resource);
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (InputStream in = loader.getResourceAsStream(resource);){
                    new ClassReader(in).accept(this.classVisitor, 0);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error scanning resource '%s': %s", resource, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
            }
        }
        return this.annotatedClasses;
    }
}

