/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.jobs.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.jobs.IJobContext;

public abstract class JobProvider
extends PlatformObject {
    public static final String SERVICE_NAME = JobProvider.class.getName();
    private static final List<String> LAZY_INITIALIZATION_PLACEHOLDER = Collections.emptyList();
    private final Lock lazyInitializationLock = new ReentrantLock();
    private volatile List<String> providedTypeIds;

    JobProvider() {
        this.providedTypeIds = LAZY_INITIALIZATION_PLACEHOLDER;
    }

    protected JobProvider(Collection<String> providedTypeIds) {
        if (providedTypeIds == null || providedTypeIds.isEmpty()) {
            throw new IllegalArgumentException("job types must not be null or empty");
        }
        this.providedTypeIds = new ArrayList<String>(providedTypeIds.size());
        for (String id : providedTypeIds) {
            if (!IdHelper.isValidId((String)id)) {
                throw new IllegalArgumentException(String.format("type id \"%s\" is invalid; valid chars are US-ASCII a-z / A-Z / 0-9 / '.' / '-' / '_'", id));
            }
            this.providedTypeIds.add(id);
        }
    }

    public abstract Job createJob(String var1, IJobContext var2) throws Exception;

    List<String> discoverProvidedTypeIds() {
        throw new IllegalStateException("Discovery not available.");
    }

    public String getName(String typeId) {
        return null;
    }

    public final Collection<String> getProvidedTypeIds() {
        List<String> ids = this.providedTypeIds;
        if (ids == LAZY_INITIALIZATION_PLACEHOLDER) {
            this.lazyInitializationLock.lock();
            try {
                if (this.providedTypeIds == LAZY_INITIALIZATION_PLACEHOLDER) {
                    ids = this.providedTypeIds = this.discoverProvidedTypeIds();
                }
            }
            finally {
                this.lazyInitializationLock.unlock();
            }
        }
        return Collections.unmodifiableCollection(ids);
    }

    public final String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " [" + StringUtils.join(this.providedTypeIds, (char)',') + "]";
    }
}

