/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.persistence.solr.config.ISolrRepositoryConfigurer;
import org.eclipse.gyrex.persistence.solr.config.SolrServerType;
import org.eclipse.gyrex.persistence.storage.registry.IRepositoryDefinition;
import org.osgi.service.prefs.BackingStoreException;

public class SolrRepositoryConfigurer
implements ISolrRepositoryConfigurer {
    private final IRepositoryDefinition repositoryDefinition;

    public SolrRepositoryConfigurer(IRepositoryDefinition repositoryDefinition) {
        this.repositoryDefinition = repositoryDefinition;
    }

    @Override
    public void flush() throws BackingStoreException {
        this.repositoryDefinition.getRepositoryPreferences().flush();
    }

    @Override
    public void setProperties(SolrServerType serverType, String serverUrl) throws IllegalArgumentException {
        this.repositoryDefinition.getRepositoryPreferences().put("serverType", serverType.toString(), false);
        if (serverUrl != null) {
            if (serverType == SolrServerType.REMOTE) {
                this.repositoryDefinition.getRepositoryPreferences().put("serverUrl", serverUrl, false);
            } else if (serverType == SolrServerType.CLOUD) {
                this.repositoryDefinition.getRepositoryPreferences().put("zkHosts", serverUrl, false);
            }
        } else {
            this.repositoryDefinition.getRepositoryPreferences().remove("serverUrl");
        }
    }

    @Override
    public void setUrls(String masterUrl, Collection<String> replicaUrls) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)masterUrl)) {
            throw new IllegalArgumentException("master url must not be null");
        }
        if (replicaUrls == null || replicaUrls.isEmpty()) {
            throw new IllegalArgumentException("at least on replica url must be specified");
        }
        this.repositoryDefinition.getRepositoryPreferences().put("serverType", SolrServerType.REMOTE.toString(), false);
        this.repositoryDefinition.getRepositoryPreferences().put("serverUrl", masterUrl, false);
        int pos = 0;
        this.repositoryDefinition.getRepositoryPreferences().remove("serverReadUrls");
        for (String replicaUrl : replicaUrls) {
            if (StringUtils.isBlank((String)replicaUrl)) {
                throw new IllegalArgumentException("invalid blank replica url found ");
            }
            this.repositoryDefinition.getRepositoryPreferences().put("serverReadUrls//" + pos, replicaUrl, false);
            ++pos;
        }
    }
}

