/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.solr.internal;

import java.util.ArrayList;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.gyrex.monitoring.metrics.BaseMetric;
import org.eclipse.gyrex.monitoring.metrics.ErrorMetric;
import org.eclipse.gyrex.monitoring.metrics.MetricSet;
import org.eclipse.gyrex.monitoring.metrics.StatusMetric;
import org.eclipse.gyrex.monitoring.metrics.ThroughputMetric;

public class SolrRepositoryMetrics
extends MetricSet {
    private final StatusMetric statusMetric = (StatusMetric)this.getMetric(0, StatusMetric.class);
    private final ErrorMetric errorMetric = (ErrorMetric)this.getMetric(1, ErrorMetric.class);
    private final BaseMetric queryMetric = this.getMetric(2, ThroughputMetric.class);
    private final BaseMetric updateMetric = this.getMetric(3, ThroughputMetric.class);
    private final BaseMetric adminMetric = this.getMetric(4, ThroughputMetric.class);
    private final BaseMetric otherMetric = this.getMetric(5, ThroughputMetric.class);

    private static BaseMetric[] createMetrics(String initialStatus, String initialStatusReason) {
        ArrayList<Object> metrics = new ArrayList<Object>(6);
        metrics.add(new StatusMetric("status", initialStatus, initialStatusReason));
        metrics.add(new ErrorMetric("error", 5));
        metrics.add(new ThroughputMetric("query.throughput"));
        metrics.add(new ThroughputMetric("update.throughput"));
        metrics.add(new ThroughputMetric("admin.throughput"));
        metrics.add(new ThroughputMetric("other.throughput"));
        return metrics.toArray(new BaseMetric[metrics.size()]);
    }

    protected SolrRepositoryMetrics(String id, String repositoryId, String initialStatus, String initialStatusReason) {
        super(id, String.format("Metrics for repository %s", repositoryId), SolrRepositoryMetrics.createMetrics(initialStatus, initialStatusReason));
    }

    public ThroughputMetric getAdminThroughputMetric() {
        return (ThroughputMetric)this.adminMetric;
    }

    private String getErrorDetails(String requestInfo, Exception exception) {
        String[] rootCauseStackTrace;
        StrBuilder builder = new StrBuilder();
        builder.appendln("REQUEST");
        builder.appendln(requestInfo);
        builder.appendNewLine();
        builder.appendln("EXCEPTION");
        String[] stringArray = rootCauseStackTrace = ExceptionUtils.getRootCauseStackTrace((Throwable)exception);
        int n = rootCauseStackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            builder.appendln(line);
            ++n2;
        }
        return builder.toString();
    }

    public ErrorMetric getErrorMetric() {
        return this.errorMetric;
    }

    public ThroughputMetric getOtherThroughputMetric() {
        return (ThroughputMetric)this.otherMetric;
    }

    public ThroughputMetric getQueryThroughputMetric() {
        return (ThroughputMetric)this.queryMetric;
    }

    public StatusMetric getStatusMetric() {
        return this.statusMetric;
    }

    public ThroughputMetric getUpdateThroughputMetric() {
        return (ThroughputMetric)this.updateMetric;
    }

    public void recordException(String requestInfo, Exception exception) {
        String error = ExceptionUtils.getRootCauseMessage((Throwable)exception);
        String errorDetails = this.getErrorDetails(requestInfo, exception);
        this.getErrorMetric().setLastError(error, errorDetails);
    }

    public void setClosed(String reason) {
        this.getStatusMetric().setStatus("closed", reason);
    }
}

