/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.FastOutputStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrDeletionPolicy;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.RequestHandlerUtils;
import org.apache.solr.handler.SnapPuller;
import org.apache.solr.handler.SnapShooter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicationHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private static final Logger LOG = LoggerFactory.getLogger((String)ReplicationHandler.class.getName());
    SolrCore core;
    private SnapPuller snapPuller;
    private ReentrantLock snapPullLock = new ReentrantLock();
    private String includeConfFiles;
    private NamedList<String> confFileNameAlias = new NamedList();
    private boolean isMaster = false;
    private boolean isSlave = false;
    private boolean replicateOnOptimize = false;
    private boolean replicateOnCommit = false;
    private boolean replicateOnStart = false;
    private int numTimesReplicated = 0;
    private final Map<String, FileInfo> confFileInfoCache = new HashMap<String, FileInfo>();
    private Integer reserveCommitDuration = SnapPuller.readInterval("00:00:10");
    private volatile IndexCommit indexCommitPoint;
    volatile NamedList snapShootDetails;
    private AtomicBoolean replicationEnabled = new AtomicBoolean(true);
    private volatile SnapPuller tempSnapPuller;
    public static final String MASTER_URL = "masterUrl";
    public static final String STATUS = "status";
    public static final String COMMAND = "command";
    public static final String CMD_DETAILS = "details";
    public static final String CMD_BACKUP = "backup";
    public static final String CMD_FETCH_INDEX = "fetchindex";
    public static final String CMD_ABORT_FETCH = "abortfetch";
    public static final String CMD_GET_FILE_LIST = "filelist";
    public static final String CMD_GET_FILE = "filecontent";
    public static final String CMD_FILE_CHECKSUM = "filechecksum";
    public static final String CMD_DISABLE_POLL = "disablepoll";
    public static final String CMD_DISABLE_REPL = "disablereplication";
    public static final String CMD_ENABLE_REPL = "enablereplication";
    public static final String CMD_ENABLE_POLL = "enablepoll";
    public static final String CMD_INDEX_VERSION = "indexversion";
    public static final String CMD_SHOW_COMMITS = "commits";
    public static final String GENERATION = "generation";
    public static final String OFFSET = "offset";
    public static final String LEN = "len";
    public static final String FILE = "file";
    public static final String NAME = "name";
    public static final String SIZE = "size";
    public static final String LAST_MODIFIED = "lastmodified";
    public static final String CONF_FILE_SHORT = "cf";
    public static final String CHECKSUM = "checksum";
    public static final String ALIAS = "alias";
    public static final String CONF_CHECKSUM = "confchecksum";
    public static final String CONF_FILES = "confFiles";
    public static final String REPLICATE_AFTER = "replicateAfter";
    public static final String FILE_STREAM = "filestream";
    public static final int PACKET_SZ = 0x100000;
    public static final String RESERVE = "commitReserveDuration";
    public static final String COMPRESSION = "compression";
    public static final String EXTERNAL = "external";
    public static final String INTERNAL = "internal";
    public static final String ERR_STATUS = "ERROR";
    public static final String OK_STATUS = "OK";
    public static final String NEXT_EXECUTION_AT = "nextExecutionAt";
    public static final String NUMBER_BACKUPS_TO_KEEP = "numberToKeep";

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        rsp.setHttpCaching(false);
        SolrParams solrParams = req.getParams();
        String command = solrParams.get(COMMAND);
        if (command == null) {
            rsp.add(STATUS, OK_STATUS);
            rsp.add("message", "No command");
            return;
        }
        if (command.equals(CMD_INDEX_VERSION)) {
            IndexCommit commitPoint = this.indexCommitPoint;
            if (commitPoint != null && this.replicationEnabled.get()) {
                this.core.getDeletionPolicy().setReserveDuration(commitPoint.getVersion(), this.reserveCommitDuration.intValue());
                rsp.add(CMD_INDEX_VERSION, commitPoint.getVersion());
                rsp.add(GENERATION, commitPoint.getGeneration());
            } else {
                rsp.add(CMD_INDEX_VERSION, 0L);
                rsp.add(GENERATION, 0L);
            }
        } else if (command.equals(CMD_GET_FILE)) {
            this.getFileStream(solrParams, rsp);
        } else if (command.equals(CMD_GET_FILE_LIST)) {
            this.getFileList(solrParams, rsp);
        } else if (command.equalsIgnoreCase(CMD_BACKUP)) {
            this.doSnapShoot((SolrParams)new ModifiableSolrParams(solrParams), rsp, req);
            rsp.add(STATUS, OK_STATUS);
        } else if (command.equalsIgnoreCase(CMD_FETCH_INDEX)) {
            String masterUrl = solrParams.get(MASTER_URL);
            if (!this.isSlave && masterUrl == null) {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured or no 'masterUrl' Specified");
                return;
            }
            ModifiableSolrParams paramsCopy = new ModifiableSolrParams(solrParams);
            new Thread((SolrParams)paramsCopy){
                final /* synthetic */ SolrParams val$paramsCopy;
                {
                    this.val$paramsCopy = solrParams;
                }

                public void run() {
                    ReplicationHandler.this.doFetch(this.val$paramsCopy);
                }
            }.start();
            rsp.add(STATUS, OK_STATUS);
        } else if (command.equalsIgnoreCase(CMD_DISABLE_POLL)) {
            if (this.snapPuller != null) {
                this.snapPuller.disablePoll();
                rsp.add(STATUS, OK_STATUS);
            } else {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured");
            }
        } else if (command.equalsIgnoreCase(CMD_ENABLE_POLL)) {
            if (this.snapPuller != null) {
                this.snapPuller.enablePoll();
                rsp.add(STATUS, OK_STATUS);
            } else {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured");
            }
        } else if (command.equalsIgnoreCase(CMD_ABORT_FETCH)) {
            SnapPuller temp = this.tempSnapPuller;
            if (temp != null) {
                temp.abortPull();
                rsp.add(STATUS, OK_STATUS);
            } else {
                rsp.add(STATUS, ERR_STATUS);
                rsp.add("message", "No slave configured");
            }
        } else if (command.equals(CMD_FILE_CHECKSUM)) {
            this.getFileChecksum(solrParams, rsp);
        } else if (command.equals(CMD_SHOW_COMMITS)) {
            rsp.add(CMD_SHOW_COMMITS, this.getCommits());
        } else if (command.equals(CMD_DETAILS)) {
            rsp.add(CMD_DETAILS, this.getReplicationDetails(solrParams.getBool("slave", true)));
            RequestHandlerUtils.addExperimentalFormatWarning(rsp);
        } else if (CMD_ENABLE_REPL.equalsIgnoreCase(command)) {
            this.replicationEnabled.set(true);
            rsp.add(STATUS, OK_STATUS);
        } else if (CMD_DISABLE_REPL.equalsIgnoreCase(command)) {
            this.replicationEnabled.set(false);
            rsp.add(STATUS, OK_STATUS);
        }
    }

    private List<NamedList> getCommits() {
        Map<Long, IndexCommit> commits = this.core.getDeletionPolicy().getCommits();
        ArrayList<NamedList> l = new ArrayList<NamedList>();
        for (IndexCommit c : commits.values()) {
            try {
                NamedList nl = new NamedList();
                nl.add("indexVersion", (Object)c.getVersion());
                nl.add(GENERATION, (Object)c.getGeneration());
                nl.add(CMD_GET_FILE_LIST, (Object)c.getFileNames());
                l.add(nl);
            }
            catch (IOException e) {
                LOG.warn("Exception while reading files for commit " + c, (Throwable)e);
            }
        }
        return l;
    }

    private void getFileChecksum(SolrParams solrParams, SolrQueryResponse rsp) {
        Adler32 checksum = new Adler32();
        File dir = new File(this.core.getIndexDir());
        rsp.add(CHECKSUM, this.getCheckSums(solrParams.getParams(FILE), dir, checksum));
        dir = new File(this.core.getResourceLoader().getConfigDir());
        rsp.add(CONF_CHECKSUM, this.getCheckSums(solrParams.getParams(CONF_FILE_SHORT), dir, checksum));
    }

    private Map<String, Long> getCheckSums(String[] files, File dir, Checksum checksum) {
        HashMap<String, Long> checksumMap = new HashMap<String, Long>();
        if (files == null || files.length == 0) {
            return checksumMap;
        }
        for (String file : files) {
            File f = new File(dir, file);
            Long checkSumVal = ReplicationHandler.getCheckSum(checksum, f);
            if (checkSumVal == null) continue;
            checksumMap.put(file, checkSumVal);
        }
        return checksumMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Long getCheckSum(Checksum checksum, File f) {
        Long l;
        FileInputStream fis = null;
        checksum.reset();
        byte[] buffer = new byte[0x100000];
        try {
            int bytesRead;
            fis = new FileInputStream(f);
            while ((bytesRead = fis.read(buffer)) >= 0) {
                checksum.update(buffer, 0, bytesRead);
            }
            l = checksum.getValue();
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                LOG.warn("Exception in finding checksum of " + f, (Throwable)e);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return null;
        }
        IOUtils.closeQuietly((InputStream)fis);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doFetch(SolrParams solrParams) {
        String masterUrl;
        String string = masterUrl = solrParams == null ? null : solrParams.get(MASTER_URL);
        if (!this.snapPullLock.tryLock()) {
            return;
        }
        try {
            try {
                this.tempSnapPuller = this.snapPuller;
                if (masterUrl != null) {
                    NamedList nl = solrParams.toNamedList();
                    nl.remove("pollInterval");
                    this.tempSnapPuller = new SnapPuller(nl, this, this.core);
                }
                this.tempSnapPuller.fetchLatestIndex(this.core);
            }
            catch (Exception e) {
                LOG.error("SnapPull failed ", (Throwable)e);
                Object var5_6 = null;
                this.tempSnapPuller = this.snapPuller;
                this.snapPullLock.unlock();
            }
            Object var5_5 = null;
            this.tempSnapPuller = this.snapPuller;
            this.snapPullLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.tempSnapPuller = this.snapPuller;
            this.snapPullLock.unlock();
            throw throwable;
        }
    }

    boolean isReplicating() {
        return this.snapPullLock.isLocked();
    }

    private void doSnapShoot(SolrParams params, SolrQueryResponse rsp, SolrQueryRequest req) {
        try {
            int numberToKeep = params.getInt(NUMBER_BACKUPS_TO_KEEP, Integer.MAX_VALUE);
            IndexDeletionPolicyWrapper delPolicy = this.core.getDeletionPolicy();
            IndexCommit indexCommit = delPolicy.getLatestCommit();
            if (indexCommit == null) {
                indexCommit = req.getSearcher().getReader().getIndexCommit();
            }
            new SnapShooter(this.core, params.get("location")).createSnapAsync(indexCommit, numberToKeep, this);
        }
        catch (Exception e) {
            LOG.warn("Exception during creating a snapshot", (Throwable)e);
            rsp.add("exception", e);
        }
    }

    private void getFileStream(SolrParams solrParams, SolrQueryResponse rsp) {
        ModifiableSolrParams rawParams = new ModifiableSolrParams(solrParams);
        rawParams.set("wt", new String[]{FILE_STREAM});
        rsp.add(FILE_STREAM, new FileStream(solrParams));
    }

    private void getFileList(SolrParams solrParams, SolrQueryResponse rsp) {
        String v = solrParams.get(CMD_INDEX_VERSION);
        if (v == null) {
            rsp.add(STATUS, "no indexversion specified");
            return;
        }
        long version = Long.parseLong(v);
        IndexCommit commit = this.core.getDeletionPolicy().getCommitPoint(version);
        if (commit == null) {
            rsp.add(STATUS, "invalid indexversion");
            return;
        }
        this.core.getDeletionPolicy().setReserveDuration(version, this.reserveCommitDuration.intValue());
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            HashSet files = new HashSet(commit.getFileNames());
            for (String fileName : files) {
                if (fileName.endsWith(".lock")) continue;
                File file = new File(this.core.getIndexDir(), fileName);
                Map<String, Object> fileMeta = this.getFileInfo(file);
                result.add(fileMeta);
            }
        }
        catch (IOException e) {
            rsp.add(STATUS, "unable to get file names for given indexversion");
            rsp.add("exception", e);
            LOG.warn("Unable to get file names for indexCommit version: " + version, (Throwable)e);
        }
        rsp.add(CMD_GET_FILE_LIST, result);
        if (this.confFileNameAlias.size() < 1) {
            return;
        }
        LOG.debug("Adding config files to list: " + this.includeConfFiles);
        rsp.add(CONF_FILES, this.getConfFileInfoFromCache(this.confFileNameAlias, this.confFileInfoCache));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Map<String, Object>> getConfFileInfoFromCache(NamedList<String> nameAndAlias, Map<String, FileInfo> confFileInfoCache) {
        ArrayList<Map<String, Object>> confFiles = new ArrayList<Map<String, Object>>();
        Map<String, FileInfo> map = confFileInfoCache;
        synchronized (map) {
            File confDir = new File(this.core.getResourceLoader().getConfigDir());
            Adler32 checksum = null;
            for (int i = 0; i < nameAndAlias.size(); ++i) {
                String cf = nameAndAlias.getName(i);
                File f = new File(confDir, cf);
                if (!f.exists() || f.isDirectory()) continue;
                FileInfo info = confFileInfoCache.get(cf);
                if (info == null || info.lastmodified != f.lastModified() || info.size != f.length()) {
                    if (checksum == null) {
                        checksum = new Adler32();
                    }
                    info = new FileInfo(f.lastModified(), cf, f.length(), ReplicationHandler.getCheckSum(checksum, f));
                    confFileInfoCache.put(cf, info);
                }
                Map<String, Object> m = info.getAsMap();
                if (nameAndAlias.getVal(i) != null) {
                    m.put(ALIAS, nameAndAlias.getVal(i));
                }
                confFiles.add(m);
            }
        }
        return confFiles;
    }

    void disablePoll() {
        if (this.isSlave) {
            this.snapPuller.disablePoll();
        }
    }

    void enablePoll() {
        if (this.isSlave) {
            this.snapPuller.enablePoll();
        }
    }

    boolean isPollingDisabled() {
        return this.snapPuller.isPollingDisabled();
    }

    int getTimesReplicatedSinceStartup() {
        return this.numTimesReplicated;
    }

    void setTimesReplicatedSinceStartup() {
        ++this.numTimesReplicated;
    }

    long getIndexSize() {
        return this.computeIndexSize(new File(this.core.getIndexDir()));
    }

    private long computeIndexSize(File f) {
        if (f.isFile()) {
            return f.length();
        }
        File[] files = f.listFiles();
        long size = 0L;
        if (files != null && files.length > 0) {
            for (File file : files) {
                size += file.length();
            }
        }
        return size;
    }

    private Map<String, Object> getFileInfo(File file) {
        HashMap<String, Object> fileMeta = new HashMap<String, Object>();
        fileMeta.put(NAME, file.getName());
        fileMeta.put(SIZE, file.length());
        fileMeta.put(LAST_MODIFIED, file.lastModified());
        return fileMeta;
    }

    @Override
    public String getDescription() {
        return "ReplicationHandler provides replication of index and configuration files from Master to Slaves";
    }

    @Override
    public String getSourceId() {
        return "$Id: ReplicationHandler.java 1203003 2011-11-17 01:50:33Z hossman $";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_3_5/solr/core/src/java/org/apache/solr/handler/ReplicationHandler.java $";
    }

    @Override
    public String getVersion() {
        return "$Revision: 1203003 $";
    }

    String readableSize(long size) {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMaximumFractionDigits(2);
        if (size / 0x40000000L > 0L) {
            return formatter.format((double)size * 1.0 / 1.073741824E9) + " GB";
        }
        if (size / 0x100000L > 0L) {
            return formatter.format((double)size * 1.0 / 1048576.0) + " MB";
        }
        if (size / 1024L > 0L) {
            return formatter.format((double)size * 1.0 / 1024.0) + " KB";
        }
        return String.valueOf(size) + " bytes";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getIndexVersion() {
        long[] version = new long[2];
        RefCounted<SolrIndexSearcher> searcher = this.core.getSearcher();
        try {
            try {
                version[0] = searcher.get().getReader().getIndexCommit().getVersion();
                version[1] = searcher.get().getReader().getIndexCommit().getGeneration();
            }
            catch (IOException e) {
                LOG.warn("Unable to get index version : ", (Throwable)e);
                Object var5_4 = null;
                searcher.decref();
            }
            Object var5_3 = null;
            searcher.decref();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            searcher.decref();
            throw throwable;
        }
        return version;
    }

    @Override
    public NamedList getStatistics() {
        NamedList list = super.getStatistics();
        if (this.core != null) {
            list.add("indexSize", (Object)this.readableSize(this.getIndexSize()));
            long[] versionGen = this.getIndexVersion();
            list.add("indexVersion", (Object)versionGen[0]);
            list.add(GENERATION, (Object)versionGen[1]);
            list.add("indexPath", (Object)this.core.getIndexDir());
            list.add("isMaster", (Object)String.valueOf(this.isMaster));
            list.add("isSlave", (Object)String.valueOf(this.isSlave));
            SnapPuller snapPuller = this.tempSnapPuller;
            if (snapPuller != null) {
                list.add(MASTER_URL, (Object)snapPuller.getMasterUrl());
                if (snapPuller.getPollInterval() != null) {
                    list.add("pollInterval", (Object)snapPuller.getPollInterval());
                }
                list.add("isPollingDisabled", (Object)String.valueOf(this.isPollingDisabled()));
                list.add("isReplicating", (Object)String.valueOf(this.isReplicating()));
                long elapsed = this.getTimeElapsed(snapPuller);
                long val = SnapPuller.getTotalBytesDownloaded(snapPuller);
                if (elapsed > 0L) {
                    list.add("timeElapsed", (Object)elapsed);
                    list.add("bytesDownloaded", (Object)val);
                    list.add("downloadSpeed", (Object)(val / elapsed));
                }
                Properties props = this.loadReplicationProperties();
                this.addVal(list, "previousCycleTimeInSeconds", props, Long.class);
                this.addVal(list, "indexReplicatedAt", props, Date.class);
                this.addVal(list, "confFilesReplicatedAt", props, Date.class);
                this.addVal(list, "replicationFailedAt", props, Date.class);
                this.addVal(list, "timesFailed", props, Integer.class);
                this.addVal(list, "timesIndexReplicated", props, Integer.class);
                this.addVal(list, "lastCycleBytesDownloaded", props, Long.class);
                this.addVal(list, "timesConfigReplicated", props, Integer.class);
                this.addVal(list, "confFilesReplicated", props, String.class);
            }
            if (this.isMaster) {
                if (this.includeConfFiles != null) {
                    list.add("confFilesToReplicate", (Object)this.includeConfFiles);
                }
                list.add(REPLICATE_AFTER, this.getReplicateAfterStrings());
                list.add("replicationEnabled", (Object)String.valueOf(this.replicationEnabled.get()));
            }
        }
        return list;
    }

    private NamedList<Object> getReplicationDetails(boolean showSlaveDetails) {
        NamedList snapshotStats;
        SimpleOrderedMap details = new SimpleOrderedMap();
        SimpleOrderedMap master = new SimpleOrderedMap();
        SimpleOrderedMap slave = new SimpleOrderedMap();
        details.add("indexSize", (Object)this.readableSize(this.getIndexSize()));
        details.add("indexPath", (Object)this.core.getIndexDir());
        details.add(CMD_SHOW_COMMITS, this.getCommits());
        details.add("isMaster", (Object)String.valueOf(this.isMaster));
        details.add("isSlave", (Object)String.valueOf(this.isSlave));
        long[] versionAndGeneration = this.getIndexVersion();
        details.add("indexVersion", (Object)versionAndGeneration[0]);
        details.add(GENERATION, (Object)versionAndGeneration[1]);
        IndexCommit commit = this.indexCommitPoint;
        if (this.isMaster) {
            if (this.includeConfFiles != null) {
                master.add(CONF_FILES, (Object)this.includeConfFiles);
            }
            master.add(REPLICATE_AFTER, this.getReplicateAfterStrings());
            master.add("replicationEnabled", (Object)String.valueOf(this.replicationEnabled.get()));
        }
        if (this.isMaster && commit != null) {
            master.add("replicatableIndexVersion", (Object)commit.getVersion());
            master.add("replicatableGeneration", (Object)commit.getGeneration());
        }
        SnapPuller snapPuller = this.tempSnapPuller;
        if (showSlaveDetails && snapPuller != null) {
            Properties props = this.loadReplicationProperties();
            try {
                NamedList command = new NamedList();
                command.add(COMMAND, (Object)CMD_DETAILS);
                command.add("slave", (Object)"false");
                NamedList nl = snapPuller.getCommandResponse((NamedList<String>)command);
                slave.add("masterDetails", nl.get(CMD_DETAILS));
            }
            catch (Exception e) {
                LOG.warn("Exception while invoking 'details' method for replication on master ", (Throwable)e);
                slave.add(ERR_STATUS, (Object)"invalid_master");
            }
            slave.add(MASTER_URL, (Object)snapPuller.getMasterUrl());
            if (snapPuller.getPollInterval() != null) {
                slave.add("pollInterval", (Object)snapPuller.getPollInterval());
            }
            if (snapPuller.getNextScheduledExecTime() != null && !this.isPollingDisabled()) {
                slave.add(NEXT_EXECUTION_AT, (Object)new Date(snapPuller.getNextScheduledExecTime()).toString());
            } else if (this.isPollingDisabled()) {
                slave.add(NEXT_EXECUTION_AT, (Object)"Polling disabled");
            }
            this.addVal((NamedList)slave, "indexReplicatedAt", props, Date.class);
            this.addVal((NamedList)slave, "indexReplicatedAtList", props, List.class);
            this.addVal((NamedList)slave, "replicationFailedAtList", props, List.class);
            this.addVal((NamedList)slave, "timesIndexReplicated", props, Integer.class);
            this.addVal((NamedList)slave, "confFilesReplicated", props, Integer.class);
            this.addVal((NamedList)slave, "timesConfigReplicated", props, Integer.class);
            this.addVal((NamedList)slave, "confFilesReplicatedAt", props, Integer.class);
            this.addVal((NamedList)slave, "lastCycleBytesDownloaded", props, Long.class);
            this.addVal((NamedList)slave, "timesFailed", props, Integer.class);
            this.addVal((NamedList)slave, "replicationFailedAt", props, Date.class);
            this.addVal((NamedList)slave, "previousCycleTimeInSeconds", props, Long.class);
            slave.add("isPollingDisabled", (Object)String.valueOf(this.isPollingDisabled()));
            boolean isReplicating = this.isReplicating();
            slave.add("isReplicating", (Object)String.valueOf(isReplicating));
            if (isReplicating) {
                try {
                    long bytesToDownload = 0L;
                    ArrayList<String> filesToDownload = new ArrayList<String>();
                    for (Map<String, Object> file : snapPuller.getFilesToDownload()) {
                        filesToDownload.add((String)file.get(NAME));
                        bytesToDownload += ((Long)file.get(SIZE)).longValue();
                    }
                    for (Map<String, Object> file : snapPuller.getConfFilesToDownload()) {
                        filesToDownload.add((String)file.get(NAME));
                        bytesToDownload += ((Long)file.get(SIZE)).longValue();
                    }
                    slave.add("filesToDownload", filesToDownload);
                    slave.add("numFilesToDownload", (Object)String.valueOf(filesToDownload.size()));
                    slave.add("bytesToDownload", (Object)this.readableSize(bytesToDownload));
                    long bytesDownloaded = 0L;
                    ArrayList<String> filesDownloaded = new ArrayList<String>();
                    for (Map<String, Object> file : snapPuller.getFilesDownloaded()) {
                        filesDownloaded.add((String)file.get(NAME));
                        bytesDownloaded += ((Long)file.get(SIZE)).longValue();
                    }
                    for (Map<String, Object> file : snapPuller.getConfFilesDownloaded()) {
                        filesDownloaded.add((String)file.get(NAME));
                        bytesDownloaded += ((Long)file.get(SIZE)).longValue();
                    }
                    Map<String, Object> currentFile = snapPuller.getCurrentFile();
                    String currFile = null;
                    long currFileSize = 0L;
                    long currFileSizeDownloaded = 0L;
                    float percentDownloaded = 0.0f;
                    if (currentFile != null) {
                        currFile = (String)currentFile.get(NAME);
                        currFileSize = (Long)currentFile.get(SIZE);
                        if (currentFile.containsKey("bytesDownloaded")) {
                            currFileSizeDownloaded = (Long)currentFile.get("bytesDownloaded");
                            bytesDownloaded += currFileSizeDownloaded;
                            if (currFileSize > 0L) {
                                percentDownloaded = currFileSizeDownloaded * 100L / currFileSize;
                            }
                        }
                    }
                    slave.add("filesDownloaded", filesDownloaded);
                    slave.add("numFilesDownloaded", (Object)String.valueOf(filesDownloaded.size()));
                    long estimatedTimeRemaining = 0L;
                    if (snapPuller.getReplicationStartTime() > 0L) {
                        slave.add("replicationStartTime", (Object)new Date(snapPuller.getReplicationStartTime()).toString());
                    }
                    long elapsed = this.getTimeElapsed(snapPuller);
                    slave.add("timeElapsed", (Object)(String.valueOf(elapsed) + "s"));
                    if (bytesDownloaded > 0L) {
                        estimatedTimeRemaining = (bytesToDownload - bytesDownloaded) * elapsed / bytesDownloaded;
                    }
                    float totalPercent = 0.0f;
                    long downloadSpeed = 0L;
                    if (bytesToDownload > 0L) {
                        totalPercent = bytesDownloaded * 100L / bytesToDownload;
                    }
                    if (elapsed > 0L) {
                        downloadSpeed = bytesDownloaded / elapsed;
                    }
                    if (currFile != null) {
                        slave.add("currentFile", (Object)currFile);
                    }
                    slave.add("currentFileSize", (Object)this.readableSize(currFileSize));
                    slave.add("currentFileSizeDownloaded", (Object)this.readableSize(currFileSizeDownloaded));
                    slave.add("currentFileSizePercent", (Object)String.valueOf(percentDownloaded));
                    slave.add("bytesDownloaded", (Object)this.readableSize(bytesDownloaded));
                    slave.add("totalPercent", (Object)String.valueOf(totalPercent));
                    slave.add("timeRemaining", (Object)(String.valueOf(estimatedTimeRemaining) + "s"));
                    slave.add("downloadSpeed", (Object)this.readableSize(downloadSpeed));
                }
                catch (Exception e) {
                    LOG.error("Exception while writing replication details: ", (Throwable)e);
                }
            }
        }
        if (this.isMaster) {
            details.add("master", (Object)master);
        }
        if (this.isSlave && showSlaveDetails) {
            details.add("slave", (Object)slave);
        }
        if ((snapshotStats = this.snapShootDetails) != null) {
            details.add(CMD_BACKUP, (Object)snapshotStats);
        }
        return details;
    }

    private void addVal(NamedList nl, String key, Properties props, Class clzz) {
        String s = props.getProperty(key);
        if (s == null || s.trim().length() == 0) {
            return;
        }
        if (clzz == Date.class) {
            try {
                Long l = Long.parseLong(s);
                nl.add(key, (Object)new Date(l).toString());
            }
            catch (NumberFormatException e) {}
        } else if (clzz == List.class) {
            String[] ss = s.split(",");
            ArrayList<String> l = new ArrayList<String>();
            for (int i = 0; i < ss.length; ++i) {
                l.add(new Date(Long.valueOf(ss[i])).toString());
            }
            nl.add(key, l);
        } else {
            nl.add(key, (Object)s);
        }
    }

    private List<String> getReplicateAfterStrings() {
        ArrayList<String> replicateAfter = new ArrayList<String>();
        if (this.replicateOnCommit) {
            replicateAfter.add("commit");
        }
        if (this.replicateOnOptimize) {
            replicateAfter.add("optimize");
        }
        if (this.replicateOnStart) {
            replicateAfter.add("startup");
        }
        return replicateAfter;
    }

    private long getTimeElapsed(SnapPuller snapPuller) {
        long timeElapsed = 0L;
        if (snapPuller.getReplicationStartTime() > 0L) {
            timeElapsed = (System.currentTimeMillis() - snapPuller.getReplicationStartTime()) / 1000L;
        }
        return timeElapsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties loadReplicationProperties() {
        FileInputStream inFile = null;
        Properties props = new Properties();
        try {
            block4: {
                try {
                    File f = new File(this.core.getDataDir(), "replication.properties");
                    if (!f.exists()) break block4;
                    inFile = new FileInputStream(f);
                    props.load(inFile);
                }
                catch (Exception e) {
                    LOG.warn("Exception while reading replication.properties");
                    Object var5_6 = null;
                    IOUtils.closeQuietly(inFile);
                    return props;
                }
            }
            Object var5_5 = null;
            IOUtils.closeQuietly((InputStream)inFile);
            return props;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            IOUtils.closeQuietly(inFile);
            throw throwable;
        }
    }

    void refreshCommitpoint() {
        IndexCommit commitPoint = this.core.getDeletionPolicy().getLatestCommit();
        if (this.replicateOnCommit || this.replicateOnOptimize && commitPoint.getSegmentCount() == 1) {
            this.indexCommitPoint = commitPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inform(SolrCore core) {
        NamedList master;
        boolean enableMaster;
        this.core = core;
        this.registerFileStreamResponseWriter();
        this.registerCloseHook();
        NamedList slave = (NamedList)this.initArgs.get("slave");
        boolean enableSlave = this.isEnabled(slave);
        if (enableSlave) {
            this.tempSnapPuller = this.snapPuller = new SnapPuller(slave, this, core);
            this.isSlave = true;
        }
        if (enableMaster = this.isEnabled(master = (NamedList)this.initArgs.get("master"))) {
            String reserve;
            List backup;
            boolean backupOnCommit;
            this.includeConfFiles = (String)master.get(CONF_FILES);
            if (this.includeConfFiles != null && this.includeConfFiles.trim().length() > 0) {
                List<String> files = Arrays.asList(this.includeConfFiles.split(","));
                for (String file : files) {
                    if (file.trim().length() == 0) continue;
                    String[] strs = file.split(":");
                    this.confFileNameAlias.add(strs[0], strs.length > 1 ? strs[1] : null);
                }
                LOG.info("Replication enabled for following config files: " + this.includeConfFiles);
            }
            boolean backupOnOptimize = !(backupOnCommit = (backup = master.getAll("backupAfter")).contains("commit")) && backup.contains("optimize");
            List replicateAfter = master.getAll(REPLICATE_AFTER);
            this.replicateOnCommit = replicateAfter.contains("commit");
            boolean bl = this.replicateOnOptimize = !this.replicateOnCommit && replicateAfter.contains("optimize");
            if (this.replicateOnOptimize) {
                IndexDeletionPolicy policy;
                IndexDeletionPolicyWrapper wrapper = core.getDeletionPolicy();
                IndexDeletionPolicy indexDeletionPolicy = policy = wrapper == null ? null : wrapper.getWrappedDeletionPolicy();
                if (policy instanceof SolrDeletionPolicy) {
                    SolrDeletionPolicy solrPolicy = (SolrDeletionPolicy)policy;
                    if (solrPolicy.getMaxOptimizedCommitsToKeep() < 1) {
                        solrPolicy.setMaxOptimizedCommitsToKeep(1);
                    }
                } else {
                    LOG.warn("Replication can't call setMaxOptimizedCommitsToKeep on " + policy);
                }
            }
            if (this.replicateOnOptimize || backupOnOptimize) {
                core.getUpdateHandler().registerOptimizeCallback(this.getEventListener(backupOnOptimize, this.replicateOnOptimize));
            }
            if (this.replicateOnCommit || backupOnCommit) {
                this.replicateOnCommit = true;
                core.getUpdateHandler().registerCommitCallback(this.getEventListener(backupOnCommit, this.replicateOnCommit));
            }
            if (replicateAfter.contains("startup")) {
                this.replicateOnStart = true;
                RefCounted<SolrIndexSearcher> s = core.getNewestSearcher(false);
                try {
                    block26: {
                        try {
                            SolrIndexReader reader;
                            SolrIndexReader solrIndexReader = reader = s == null ? null : s.get().getReader();
                            if (reader != null && reader.getIndexCommit() != null && reader.getIndexCommit().getGeneration() != 1L) {
                                try {
                                    if (this.replicateOnOptimize) {
                                        Collection commits = IndexReader.listCommits((Directory)reader.directory());
                                        for (IndexCommit ic : commits) {
                                            if (ic.getSegmentCount() != 1 || this.indexCommitPoint != null && this.indexCommitPoint.getVersion() >= ic.getVersion()) continue;
                                            this.indexCommitPoint = ic;
                                        }
                                    } else {
                                        this.indexCommitPoint = reader.getIndexCommit();
                                    }
                                    Object var16_18 = null;
                                }
                                catch (Throwable throwable) {
                                    Object var16_19 = null;
                                    throw throwable;
                                }
                            }
                            if (core.getUpdateHandler() instanceof DirectUpdateHandler2) {
                                ((DirectUpdateHandler2)core.getUpdateHandler()).forceOpenWriter();
                                break block26;
                            }
                            LOG.warn("The update handler being used is not an instance or sub-class of DirectUpdateHandler2. Replicate on Startup cannot work.");
                        }
                        catch (IOException e) {
                            LOG.warn("Unable to get IndexCommit on startup", (Throwable)e);
                            Object var18_22 = null;
                            if (s != null) {
                                s.decref();
                            }
                        }
                    }
                    Object var18_21 = null;
                    if (s != null) {
                        s.decref();
                    }
                }
                catch (Throwable throwable) {
                    Object var18_23 = null;
                    if (s != null) {
                        s.decref();
                    }
                    throw throwable;
                }
            }
            if ((reserve = (String)master.get(RESERVE)) != null && !reserve.trim().equals("")) {
                this.reserveCommitDuration = SnapPuller.readInterval(reserve);
            }
            LOG.info("Commits will be reserved for  " + this.reserveCommitDuration);
            this.isMaster = true;
        }
    }

    private boolean isEnabled(NamedList params) {
        if (params == null) {
            return false;
        }
        Object enable = params.get("enable");
        if (enable == null) {
            return true;
        }
        if (enable instanceof String) {
            return StrUtils.parseBool((String)((String)enable));
        }
        return Boolean.TRUE.equals(enable);
    }

    private void registerCloseHook() {
        this.core.addCloseHook(new CloseHook(){

            public void preClose(SolrCore core) {
                if (ReplicationHandler.this.snapPuller != null) {
                    ReplicationHandler.this.snapPuller.destroy();
                }
            }

            public void postClose(SolrCore core) {
            }
        });
    }

    private void registerFileStreamResponseWriter() {
        this.core.registerResponseWriter(FILE_STREAM, new BinaryQueryResponseWriter(){

            public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse resp) throws IOException {
                FileStream stream = (FileStream)resp.getValues().get(ReplicationHandler.FILE_STREAM);
                stream.write(out);
            }

            public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
                throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
            }

            public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
                return "application/octet-stream";
            }

            public void init(NamedList args) {
            }
        });
    }

    private SolrEventListener getEventListener(final boolean snapshoot, final boolean getCommit) {
        return new SolrEventListener(){

            public void init(NamedList args) {
            }

            public void postCommit() {
                IndexCommit currentCommitPoint = ReplicationHandler.this.core.getDeletionPolicy().getLatestCommit();
                if (getCommit) {
                    ReplicationHandler.this.indexCommitPoint = currentCommitPoint;
                }
                if (snapshoot) {
                    try {
                        SnapShooter snapShooter = new SnapShooter(ReplicationHandler.this.core, null);
                        snapShooter.createSnapAsync(currentCommitPoint, ReplicationHandler.this);
                    }
                    catch (Exception e) {
                        LOG.error("Exception while snapshooting", (Throwable)e);
                    }
                }
            }

            public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileInfo {
        long lastmodified;
        String name;
        long size;
        long checksum;

        public FileInfo(long lasmodified, String name, long size, long checksum) {
            this.lastmodified = lasmodified;
            this.name = name;
            this.size = size;
            this.checksum = checksum;
        }

        Map<String, Object> getAsMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(ReplicationHandler.NAME, this.name);
            map.put(ReplicationHandler.SIZE, this.size);
            map.put(ReplicationHandler.LAST_MODIFIED, this.lastmodified);
            map.put(ReplicationHandler.CHECKSUM, this.checksum);
            return map;
        }
    }

    private class FileStream {
        private SolrParams params;
        private FastOutputStream fos;
        private Long indexVersion;
        private IndexDeletionPolicyWrapper delPolicy;

        public FileStream(SolrParams solrParams) {
            this.params = solrParams;
            this.delPolicy = ReplicationHandler.this.core.getDeletionPolicy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void write(OutputStream out) throws IOException {
            String fileName = this.params.get(ReplicationHandler.FILE);
            String cfileName = this.params.get(ReplicationHandler.CONF_FILE_SHORT);
            String sOffset = this.params.get(ReplicationHandler.OFFSET);
            String sLen = this.params.get(ReplicationHandler.LEN);
            String compress = this.params.get(ReplicationHandler.COMPRESSION);
            String sChecksum = this.params.get(ReplicationHandler.CHECKSUM);
            String sindexVersion = this.params.get(ReplicationHandler.CMD_INDEX_VERSION);
            if (sindexVersion != null) {
                this.indexVersion = Long.parseLong(sindexVersion);
            }
            this.fos = Boolean.parseBoolean(compress) ? new FastOutputStream((OutputStream)new DeflaterOutputStream(out)) : new FastOutputStream(out);
            FileInputStream inputStream = null;
            int packetsWritten = 0;
            try {
                block15: {
                    try {
                        long offset = -1L;
                        int len = -1;
                        boolean useChecksum = Boolean.parseBoolean(sChecksum);
                        if (sOffset != null) {
                            offset = Long.parseLong(sOffset);
                        }
                        if (sLen != null) {
                            len = Integer.parseInt(sLen);
                        }
                        if (fileName == null && cfileName == null) {
                            this.writeNothing();
                        }
                        File file = null;
                        file = cfileName != null ? new File(ReplicationHandler.this.core.getResourceLoader().getConfigDir(), cfileName) : new File(ReplicationHandler.this.core.getIndexDir(), fileName);
                        if (file.exists() && file.canRead()) {
                            inputStream = new FileInputStream(file);
                            FileChannel channel = inputStream.getChannel();
                            if (offset != -1L) {
                                channel.position(offset);
                            }
                            byte[] buf = new byte[len == -1 || len > 0x100000 ? 0x100000 : len];
                            Adler32 checksum = null;
                            if (useChecksum) {
                                checksum = new Adler32();
                            }
                            ByteBuffer bb = ByteBuffer.wrap(buf);
                            while (true) {
                                bb.clear();
                                long bytesRead = channel.read(bb);
                                if (bytesRead <= 0L) {
                                    this.writeNothing();
                                    this.fos.close();
                                    break block15;
                                }
                                this.fos.writeInt((int)bytesRead);
                                if (useChecksum) {
                                    checksum.reset();
                                    checksum.update(buf, 0, (int)bytesRead);
                                    this.fos.writeLong(checksum.getValue());
                                }
                                this.fos.write(buf, 0, (int)bytesRead);
                                this.fos.flush();
                                if (this.indexVersion != null && packetsWritten % 5 == 0) {
                                    this.delPolicy.setReserveDuration(this.indexVersion, ReplicationHandler.this.reserveCommitDuration.intValue());
                                }
                                ++packetsWritten;
                            }
                        }
                        this.writeNothing();
                    }
                    catch (IOException e) {
                        LOG.warn("Exception while writing response for params: " + this.params, (Throwable)e);
                        Object var23_22 = null;
                        IOUtils.closeQuietly(inputStream);
                        return;
                    }
                }
                Object var23_21 = null;
                IOUtils.closeQuietly(inputStream);
                return;
            }
            catch (Throwable throwable) {
                Object var23_23 = null;
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }

        private void writeNothing() throws IOException {
            this.fos.writeInt(0);
            this.fos.flush();
        }
    }
}

