/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.context.preferences.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.preferences.IRuntimeContextPreferences;
import org.eclipse.gyrex.persistence.context.preferences.ContextPreferencesRepository;
import org.eclipse.gyrex.persistence.context.preferences.internal.ContextPreferencesRepositoryMetrics;
import org.eclipse.gyrex.persistence.context.preferences.internal.ContextPreferencesRepositoryType;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;

public class ContextPreferencesRepositoryImpl
extends ContextPreferencesRepository {
    private static final String QUALIFIER_PREFIX = ".repository__";
    private final IRuntimeContext context;
    private final String qualifier;

    public ContextPreferencesRepositoryImpl(String repositoryId, ContextPreferencesRepositoryType repositoryType, IRuntimeContext context) throws IllegalArgumentException {
        super(repositoryId, repositoryType, new ContextPreferencesRepositoryMetrics(ContextPreferencesRepositoryImpl.createMetricsId((RepositoryProvider)repositoryType, (String)repositoryId), repositoryId));
        this.context = context;
        this.qualifier = QUALIFIER_PREFIX.concat(repositoryId);
    }

    @Override
    public byte[] get(String key) throws IllegalArgumentException {
        return this.context.getPreferences().getByteArray(this.qualifier, this.verifyKey(key), null);
    }

    @Override
    public Collection<String> getKeys() throws BackingStoreException {
        return Collections.unmodifiableCollection(Arrays.asList(this.context.getPreferences().getKeys(this.qualifier)));
    }

    @Override
    public void remove(String key) throws IllegalArgumentException, BackingStoreException {
        IRuntimeContextPreferences preferences = this.context.getPreferences();
        preferences.remove(this.qualifier, this.verifyKey(key));
        preferences.flush(this.qualifier);
    }

    @Override
    public void store(String key, byte[] data) throws IllegalArgumentException, BackingStoreException {
        if (data == null) {
            throw new IllegalArgumentException(NLS.bind((String)"data must not be null (key {0}, repository {1})", (Object)key, (Object)this.getRepositoryId()));
        }
        IRuntimeContextPreferences preferences = this.context.getPreferences();
        preferences.putByteArray(this.qualifier, this.verifyKey(key), data, false);
        preferences.flush(this.qualifier);
    }

    private String verifyKey(String key) {
        if (!IdHelper.isValidId((String)key)) {
            throw new IllegalArgumentException(NLS.bind((String)"invalid key: {0} (repository {1})", (Object)key, (Object)this.getRepositoryId()));
        }
        return key;
    }
}

