/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.log.internal;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import org.eclipse.equinox.http.servlet.ExtendedHttpService;
import org.eclipse.gyrex.http.log.internal.WildfireAppender;
import org.eclipse.gyrex.http.log.wildfire.WidlfireLogWriterFilter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpLogActivator
implements BundleActivator {
    private static final Logger LOG = LoggerFactory.getLogger(HttpLogActivator.class);
    private static final WidlfireLogWriterFilter FILTER = new WidlfireLogWriterFilter();
    private WildfireAppender wa;
    private ServiceTracker<HttpService, HttpService> tracker;

    public void start(BundleContext context) throws Exception {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger rootLogger = lc.getLogger("ROOT");
        LOG.info("Adding Wildfire Appender...");
        this.wa = new WildfireAppender();
        this.wa.setContext((Context)lc);
        this.wa.setName("wildfire");
        this.wa.start();
        rootLogger.addAppender((Appender)this.wa);
        this.tracker = new ServiceTracker<HttpService, HttpService>(context, HttpService.class.getName(), null){

            public HttpService addingService(ServiceReference<HttpService> reference) {
                HttpService service = (HttpService)super.addingService(reference);
                if (service != null && service instanceof ExtendedHttpService) {
                    try {
                        ((ExtendedHttpService)service).registerFilter("/", (Filter)FILTER, null, null);
                    }
                    catch (ServletException e) {
                        e.printStackTrace();
                    }
                    catch (NamespaceException e) {
                        e.printStackTrace();
                    }
                }
                return service;
            }

            public void removedService(ServiceReference<HttpService> reference, HttpService service) {
                if (service != null && service instanceof ExtendedHttpService) {
                    try {
                        ((ExtendedHttpService)service).unregisterFilter((Filter)FILTER);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
                super.removedService(reference, (Object)service);
            }
        };
        this.tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.tracker != null) {
            this.tracker.close();
        }
        if (this.wa != null) {
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            ch.qos.logback.classic.Logger rootLogger = lc.getLogger("ROOT");
            rootLogger.detachAppender((Appender)this.wa);
            this.wa.stop();
            this.wa = null;
        }
    }
}

