/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.server.settings;

import java.util.Objects;
import org.eclipse.gyrex.server.settings.SystemSetting;

public final class SystemSettingBuilder<T> {
    private final Class<T> type;
    private String environmentVariable;
    private String systemProperty;
    private String description;
    private T defaultValue;

    static String toEnvironmentVariableName(CharSequence systemProperty) {
        StringBuilder result = new StringBuilder(systemProperty.length());
        int i = 0;
        while (i < systemProperty.length()) {
            char c = systemProperty.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                result.append(c);
            } else {
                result.append('_');
            }
            ++i;
        }
        return result.toString();
    }

    SystemSettingBuilder(Class<T> valueType) {
        this.type = valueType;
    }

    public SystemSetting<T> create() {
        if (this.environmentVariable == null) {
            return new SystemSetting<T>(SystemSettingBuilder.toEnvironmentVariableName(Objects.requireNonNull(this.systemProperty, "Please specify at least a system property!")), this.systemProperty, this.description, this.type, this.defaultValue);
        }
        return new SystemSetting<T>(this.environmentVariable, this.systemProperty, this.description, this.type, this.defaultValue);
    }

    public SystemSettingBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public SystemSettingBuilder<T> environmentVariable(String environmentVariable) {
        this.environmentVariable = environmentVariable;
        return this;
    }

    public SystemSettingBuilder<T> systemProperty(String systemProperty) {
        this.systemProperty = systemProperty;
        return this;
    }

    public SystemSettingBuilder<T> usingDefault(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }
}

