/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.http.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.gyrex.admin.ui.adapter.AdapterUtil;
import org.eclipse.gyrex.admin.ui.adapter.LabelAdapter;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationBrowserContentProvider;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationGroup;
import org.eclipse.gyrex.admin.ui.http.internal.ApplicationItem;
import org.eclipse.gyrex.admin.ui.http.internal.EditApplicationDialog;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiActivator;
import org.eclipse.gyrex.admin.ui.http.internal.HttpUiAdapter;
import org.eclipse.gyrex.admin.ui.internal.application.AdminUiUtil;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.AdminPageWithTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.FilteredTree;
import org.eclipse.gyrex.admin.ui.internal.widgets.Infobox;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class HttpApplicationPage
extends AdminPageWithTree {
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_MOUNTS = 2;
    private Button editButton;
    private Button addButton;
    private Button removeButton;
    private Button activateButton;
    private Button deactivateButton;
    Image activeApplication;
    Image inactiveApplication;

    public HttpApplicationPage() {
        super(3);
        this.setTitle("Manage Web Applications");
        this.setTitleToolTip("Define, configure and mount applications.");
    }

    void activateSelectedApplications() {
        List<ApplicationItem> selectedAppRegs = this.getSelectedAppRegs();
        for (ApplicationItem item : selectedAppRegs) {
            ApplicationRegistration app = item.getApplicationRegistration();
            this.getApplicationManager().activate(app.getApplicationId());
            item.setActive(true);
            this.getTreeViewer().refresh((Object)item, true);
        }
        this.updateButtons();
    }

    void addButtonPressed() {
        EditApplicationDialog dialog = new EditApplicationDialog(SwtUtil.getShell((Widget)this.addButton), this.getApplicationManager(), null);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    HttpApplicationPage.this.refresh();
                }
            }
        });
    }

    protected void createButtons(Composite parent) {
        this.addButton = this.createButton(parent, "New...");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.addButtonPressed();
            }
        });
        this.editButton = this.createButton(parent, "Edit...");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.editSelectedApplication();
            }
        });
        this.removeButton = this.createButton(parent, "Remove");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.removeSelectedApplication();
            }
        });
        this.createButtonSeparator(parent);
        this.activateButton = this.createButton(parent, "Activate");
        this.activateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.activateSelectedApplications();
            }
        });
        this.deactivateButton = this.createButton(parent, "Deactivate");
        this.deactivateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent event) {
                HttpApplicationPage.this.deactivateSelectedApplications();
            }
        });
    }

    protected ITreeContentProvider createContentProvider() {
        return new ApplicationBrowserContentProvider();
    }

    protected Control createHeader(Composite parent) {
        Infobox infobox = new Infobox(parent);
        infobox.setLayoutData((Object)AdminUiUtil.createHorzFillData());
        infobox.addHeading("Web Applications in Gyrex.");
        infobox.addParagraph("In OSGi the HttpService is a common way of making Servlets and resources available. Out of the box (in development only) an HttpService is also available in Gyrex. However, that approache does not scale very well in a multi-tenant environment. Therefore, Gyrex allows to develop and integrate multiple kind of web applications. The OSGi HttpService is just one available example of a web application. It's possible to <a href=\"http://wiki.eclipse.org/Gyrex/Developer_Guide/Web_Applications\">develop your own applications</a>.");
        infobox.addParagraph("In order to make a new application accessible an instance need to be defined first and then it needs to be mounted to an URL.");
        return infobox;
    }

    protected FilteredTree createTree(Composite parent) {
        this.activeApplication = HttpUiActivator.getImageDescriptor("icons/obj/app_active.gif").createImage((Device)parent.getDisplay());
        this.inactiveApplication = HttpUiActivator.getImageDescriptor("icons/obj/app_inactive.gif").createImage((Device)parent.getDisplay());
        parent.addDisposeListener(new DisposeListener(){
            private static final long serialVersionUID = 1L;

            public void widgetDisposed(DisposeEvent event) {
                if (HttpApplicationPage.this.activeApplication != null) {
                    HttpApplicationPage.this.activeApplication.dispose();
                    HttpApplicationPage.this.activeApplication = null;
                }
                if (HttpApplicationPage.this.inactiveApplication != null) {
                    HttpApplicationPage.this.inactiveApplication.dispose();
                    HttpApplicationPage.this.inactiveApplication = null;
                }
            }
        });
        return super.createTree(parent);
    }

    void deactivateSelectedApplications() {
        List<ApplicationItem> selectedAppRegs = this.getSelectedAppRegs();
        for (ApplicationItem item : selectedAppRegs) {
            ApplicationRegistration app = item.getApplicationRegistration();
            this.getApplicationManager().deactivate(app.getApplicationId());
            item.setActive(false);
            this.getTreeViewer().refresh((Object)item);
        }
        this.updateButtons();
    }

    void editSelectedApplication() {
        if (this.getSelectedValue() == null) {
            return;
        }
        ApplicationRegistration app = this.getSelectedValue().getApplicationRegistration();
        EditApplicationDialog dialog = new EditApplicationDialog(SwtUtil.getShell((Widget)this.editButton), this.getApplicationManager(), app);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    HttpApplicationPage.this.refresh();
                }
            }
        });
    }

    private ApplicationManager getApplicationManager() {
        return HttpUiActivator.getAppManager();
    }

    protected String getColumnLabel(int column) {
        switch (column) {
            case 0: {
                return "Application";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Mounts";
            }
        }
        return "";
    }

    protected Image getElementImage(Object element, int column) {
        if (element instanceof ApplicationItem && column == 0) {
            ApplicationItem appItem = (ApplicationItem)element;
            if (appItem.isActive()) {
                return this.activeApplication;
            }
            return this.inactiveApplication;
        }
        return null;
    }

    protected String getElementLabel(Object element, int column) {
        if (element instanceof TreeNode) {
            Object value;
            if (column == 0 && (value = ((TreeNode)element).getValue()) instanceof ContextDefinition) {
                ContextDefinition contextDefinition = (ContextDefinition)value;
                if (StringUtils.isNotBlank((String)contextDefinition.getName())) {
                    return contextDefinition.getName();
                }
                return contextDefinition.getPath().toString();
            }
        } else {
            if (element instanceof ApplicationGroup) {
                IRuntimeContext value = ((ApplicationGroup)element).getValue();
                switch (column) {
                    case -1: 
                    case 0: {
                        LabelAdapter adapter = (LabelAdapter)AdapterUtil.getAdapter((Object)value, LabelAdapter.class);
                        if (adapter != null) {
                            return adapter.getLabel((Object)value);
                        }
                        return String.valueOf(value);
                    }
                }
                return "";
            }
            if (element instanceof ApplicationItem) {
                ApplicationItem app = (ApplicationItem)element;
                switch (column) {
                    case 0: {
                        return app.getApplicationId();
                    }
                    case 1: {
                        return HttpUiAdapter.getLabel(app.getApplicationProviderRegistration());
                    }
                    case 2: {
                        return StringUtils.join(app.getMounts(), (String)", ");
                    }
                }
                return "";
            }
        }
        return "";
    }

    private List<ApplicationItem> getSelectedAppRegs() {
        ArrayList<ApplicationItem> selectedOnes = new ArrayList<ApplicationItem>();
        TreeSelection selection = (TreeSelection)this.getTreeViewer().getSelection();
        for (Object element : selection) {
            if (!(element instanceof ApplicationItem)) continue;
            selectedOnes.add((ApplicationItem)element);
        }
        return selectedOnes;
    }

    private ApplicationItem getSelectedValue() {
        TreeSelection selection = (TreeSelection)this.getTreeViewer().getSelection();
        if (!selection.isEmpty() && selection.getFirstElement() instanceof ApplicationItem) {
            return (ApplicationItem)selection.getFirstElement();
        }
        return null;
    }

    protected Object getViewerInput() {
        return HttpUiActivator.getAppManager();
    }

    protected boolean isColumnSortable(int column) {
        return column == 0 || column == 1 || column == 2;
    }

    protected void refresh() {
        this.getTreeViewer().refresh();
    }

    void removeSelectedApplication() {
        final ApplicationItem applicationItem = this.getSelectedValue();
        if (applicationItem == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.getTreeViewer().getTree()), (String)"Remove Application", (String)String.format("Do you really want to delete instance %s?", applicationItem.getApplicationId()), (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode != 0) {
                    return;
                }
                HttpApplicationPage.this.getApplicationManager().unregister(applicationItem.getApplicationId());
                HttpApplicationPage.this.refresh();
            }
        });
    }

    protected void updateButtons() {
        int selectedElementsCount = ((IStructuredSelection)this.getTreeViewer().getSelection()).size();
        if (selectedElementsCount == 0) {
            this.activateButton.setEnabled(false);
            this.deactivateButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            return;
        }
        boolean hasActiveApps = false;
        boolean hasInactiveApps = false;
        for (Object object : (IStructuredSelection)this.getTreeViewer().getSelection()) {
            if (object instanceof ApplicationItem) {
                ApplicationItem nodeItem = (ApplicationItem)object;
                hasActiveApps |= nodeItem.isActive();
                hasInactiveApps |= !nodeItem.isActive();
            }
            if (hasInactiveApps && hasActiveApps) break;
        }
        this.activateButton.setEnabled(hasInactiveApps);
        this.deactivateButton.setEnabled(hasActiveApps);
        this.editButton.setEnabled(selectedElementsCount == 1);
        this.removeButton.setEnabled(selectedElementsCount == 1);
    }
}

