/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.http.internal;

import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang.text.StrBuilder;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.http.application.manager.ApplicationRegistrationException;
import org.eclipse.gyrex.http.application.manager.IApplicationManager;
import org.eclipse.gyrex.http.internal.HttpActivator;
import org.eclipse.gyrex.http.internal.HttpDebug;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationManager;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistration;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationProviderRegistry;
import org.eclipse.gyrex.http.internal.application.manager.ApplicationRegistration;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class HttpConsoleCommands
implements CommandProvider {
    static final Map<String, Command> commands = new TreeMap<String, Command>();

    static {
        commands.put("ls", new Command("<applications|providers|urls> - lists registered applications or providers"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                block5: {
                    String what;
                    block6: {
                        block4: {
                            what = ci.nextArgument();
                            if (StringUtils.isBlank((String)what)) {
                                ci.println((Object)"ERROR: please specify what to list");
                                ci.println((Object)this.getHelp());
                                return;
                            }
                            if (!StringUtils.startsWith((String)"applications", (String)what) && !StringUtils.startsWith((String)"apps", (String)what)) break block4;
                            TreeSet<String> registeredApplications = new TreeSet<String>(manager.getRegisteredApplications());
                            for (String applicationId : registeredApplications) {
                                ApplicationRegistration applicationRegistration = manager.getApplicationRegistration(applicationId);
                                ci.println((Object)String.format("%s (%s) [%s]", applicationRegistration.getApplicationId(), applicationRegistration.getProviderId(), applicationRegistration.getContext().getContextPath().toString()));
                            }
                            break block5;
                        }
                        if (!StringUtils.startsWith((String)"providers", (String)what)) break block6;
                        TreeMap<String, ApplicationProviderRegistration> providers = new TreeMap<String, ApplicationProviderRegistration>(registry.getRegisteredProviders());
                        for (ApplicationProviderRegistration provider : providers.values()) {
                            ci.println((Object)String.format("%s (%s) [%s]", provider.getProviderId(), provider.getProviderInfo(), provider.getContributorInfo()));
                        }
                        break block5;
                    }
                    if (!StringUtils.startsWith((String)"urls", (String)what)) break block5;
                    IEclipsePreferences urlsNode = ApplicationManager.getUrlsNode();
                    TreeSet<String> urls = new TreeSet<String>(Arrays.asList(urlsNode.keys()));
                    for (String url : urls) {
                        ci.println((Object)String.format("%s --> %s", url, urlsNode.get(url, "")));
                    }
                }
            }
        });
        commands.put("defineApp", new Command("<applicationId> <providerId> <contextPath> - defines an application"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String appId = ci.nextArgument();
                if (StringUtils.isBlank((String)appId)) {
                    ci.println((Object)"ERROR: please specify an application id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)appId)) {
                    ci.println((Object)"ERROR: invalid application id");
                    return;
                }
                String providerId = ci.nextArgument();
                if (StringUtils.isBlank((String)providerId)) {
                    ci.println((Object)"ERROR: please specify a provider id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)providerId)) {
                    ci.println((Object)"ERROR: invalid provider id");
                    return;
                }
                if (registry.getProviderRegistration(providerId) == null) {
                    ci.println((Object)String.format("ERROR: provider '%s' not found", providerId));
                    return;
                }
                IRuntimeContextRegistry contextRegistry = (IRuntimeContextRegistry)HttpActivator.getInstance().getService(IRuntimeContextRegistry.class);
                String contextPath = ci.nextArgument();
                if (StringUtils.isBlank((String)contextPath)) {
                    ci.println((Object)"ERROR: please specify a context path");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!Path.EMPTY.isValidPath(contextPath)) {
                    ci.println((Object)"ERROR: invalid context path");
                    return;
                }
                IRuntimeContext context = contextRegistry.get((IPath)new Path(contextPath));
                if (context == null) {
                    ci.println((Object)String.format("ERROR: context '%s' not found", contextPath));
                    return;
                }
                try {
                    manager.register(appId, providerId, context, null);
                }
                catch (ApplicationRegistrationException e) {
                    ci.println((Object)String.format("ERROR: Application with id '%s' already defined!", appId));
                    return;
                }
                ci.println((Object)String.format("Registered application '%s' (of type %s).", appId, providerId));
            }
        });
        commands.put("removeApp", new Command("<applicationId> - removes an application definition (will also unmount all URLs)"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String appId = ci.nextArgument();
                if (StringUtils.isBlank((String)appId)) {
                    ci.println((Object)"ERROR: please specify an application id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)appId)) {
                    ci.println((Object)"ERROR: invalid application id");
                    return;
                }
                manager.unregister(appId);
                ci.println((Object)String.format("Unregistered application '%s'.", appId));
            }
        });
        commands.put("setAppProperty", new Command("<applicationId> <propertyKey> [<propertyValue>] - sets /or unsets an application property"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String appId = ci.nextArgument();
                if (StringUtils.isBlank((String)appId)) {
                    ci.println((Object)"ERROR: please specify an application id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)appId)) {
                    ci.println((Object)"ERROR: invalid application id");
                    return;
                }
                String key = ci.nextArgument();
                if (StringUtils.isBlank((String)key)) {
                    ci.println((Object)"ERROR: please specify a property key");
                    ci.println((Object)this.getHelp());
                    return;
                }
                Map<String, String> properties = manager.getProperties(appId);
                if (properties == null) {
                    ci.println((Object)String.format("ERROR: application '%s' not found", appId));
                    return;
                }
                String value = ci.nextArgument();
                if (StringUtils.isNotBlank((String)value)) {
                    properties.put(key, value);
                    manager.setProperties(appId, properties);
                    ci.println((Object)String.format("Updated property '%s'", key));
                } else if (properties.containsKey(key)) {
                    properties.remove(key);
                    manager.setProperties(appId, properties);
                    ci.println((Object)String.format("Removed property '%s'", key));
                }
            }
        });
        commands.put("mount", new Command("<applicationId> <url> - mounts an application at the specified URL"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String appId = ci.nextArgument();
                if (StringUtils.isBlank((String)appId)) {
                    ci.println((Object)"ERROR: please specify an application id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)appId)) {
                    ci.println((Object)"ERROR: invalid application id");
                    return;
                }
                String url = ci.nextArgument();
                if (StringUtils.isBlank((String)url)) {
                    ci.println((Object)"ERROR: please specify an url");
                    ci.println((Object)this.getHelp());
                    return;
                }
                manager.mount(url, appId);
                ci.println((Object)String.format("mounted url %s", url));
            }
        });
        commands.put("unmount", new Command("<url> - unmounts the specified URL"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String url = ci.nextArgument();
                if (StringUtils.isBlank((String)url)) {
                    ci.println((Object)"ERROR: please specify an url");
                    ci.println((Object)this.getHelp());
                    return;
                }
                try {
                    manager.unmount(url);
                }
                catch (IllegalArgumentException e) {
                    ci.println((Object)String.format("ERROR: invalid url: %s", e.getMessage()));
                }
                catch (MalformedURLException e) {
                    ci.println((Object)String.format("ERROR: invalid url: %s", e.getMessage()));
                }
                catch (IllegalStateException e) {
                    ci.println((Object)String.format("ERROR: no application mounted at url %s", url));
                }
                ci.println((Object)String.format("unmounted url %s", url));
            }
        });
        commands.put("start", new Command("<applicationId> - starts an application"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String appId = ci.nextArgument();
                if (StringUtils.isBlank((String)appId)) {
                    ci.println((Object)"ERROR: please specify an application id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)appId)) {
                    ci.println((Object)"ERROR: invalid application id");
                    return;
                }
                manager.activate(appId);
            }
        });
        commands.put("stop", new Command("<applicationId> - stops an application"){

            @Override
            public void execute(ApplicationProviderRegistry registry, ApplicationManager manager, CommandInterpreter ci) throws Exception {
                String appId = ci.nextArgument();
                if (StringUtils.isBlank((String)appId)) {
                    ci.println((Object)"ERROR: please specify an application id");
                    ci.println((Object)this.getHelp());
                    return;
                }
                if (!IdHelper.isValidId((String)appId)) {
                    ci.println((Object)"ERROR: invalid application id");
                    return;
                }
                manager.deactivate(appId);
            }
        });
    }

    static void printHelp(CommandInterpreter ci) {
        ci.println((Object)"http <cmd> [args]");
        for (String cmd : commands.keySet()) {
            ci.println((Object)("\t" + cmd + " " + commands.get(cmd).getHelp()));
        }
    }

    public void _http(CommandInterpreter ci) throws Exception {
        ApplicationProviderRegistry registry;
        ApplicationManager manager;
        String command = ci.nextArgument();
        if (command == null) {
            HttpConsoleCommands.printHelp(ci);
            return;
        }
        Command cmd = commands.get(command);
        if (cmd == null) {
            ci.println((Object)("ERROR: unknown command " + command));
            HttpConsoleCommands.printHelp(ci);
            return;
        }
        try {
            manager = (ApplicationManager)HttpActivator.getInstance().getService(IApplicationManager.class);
            registry = HttpActivator.getInstance().getProviderRegistry();
        }
        catch (Exception e) {
            ci.println((Object)("ERROR: Required services not available! " + e.getMessage()));
            return;
        }
        try {
            cmd.execute(registry, manager, ci);
        }
        catch (Exception e) {
            if (HttpDebug.debug) {
                ci.printStackTrace((Throwable)e);
            }
            ci.println((Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    public String getHelp() {
        StrBuilder help = new StrBuilder(512);
        help.appendln("---Http Application Commands---");
        help.appendln("\thttp <cmd> [args]");
        for (String cmd : commands.keySet()) {
            help.appendln("\t\t" + cmd + " " + commands.get(cmd).getHelp());
        }
        return help.toString();
    }

    static abstract class Command {
        private final String help;

        public Command(String help) {
            this.help = help;
        }

        public abstract void execute(ApplicationProviderRegistry var1, ApplicationManager var2, CommandInterpreter var3) throws Exception;

        public String getHelp() {
            return this.help;
        }

        protected void printInvalidArgs(String errorMessage, CommandInterpreter ci) {
            ci.println((Object)("ERROR: invalid arguments: " + errorMessage));
            ci.println((Object)("\t" + this.getHelp()));
        }
    }
}

