/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.logback.internal.commonapenders;

import ch.qos.logback.classic.Level;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.DialogField;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.LayoutUtil;
import org.eclipse.gyrex.admin.ui.internal.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.gyrex.admin.ui.logback.configuration.wizard.AppenderConfigurationWizardSession;
import org.eclipse.gyrex.logback.config.model.Appender;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class AppenderThresholdWizardPage
extends WizardPage {
    private static final long serialVersionUID = 1L;
    private static final int IDX_NONE = 0;
    private static final int IDX_DEBUG = 1;
    private static final int IDX_INFO = 2;
    private static final int IDX_WARN = 3;
    private static final int IDX_ERROR = 4;
    private final SelectionButtonDialogFieldGroup thresholdField = new SelectionButtonDialogFieldGroup(16, new String[]{"No filter", "DEBUG", "INFO", "WARN", "ERROR"}, 1);
    private final AppenderConfigurationWizardSession session;

    public AppenderThresholdWizardPage(AppenderConfigurationWizardSession session) {
        super("threshold");
        this.session = session;
        this.setTitle("Appender Threshold");
        this.setDescription("Configure an appender threshold.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().minSize(this.convertVerticalDLUsToPixels(200), this.convertHorizontalDLUsToPixels(400)).create());
        this.setControl((Control)composite);
        this.thresholdField.setLabelText("Only log events with a severity equal to or higher than:");
        IDialogFieldListener validateListener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AppenderThresholdWizardPage.this.validate();
            }
        };
        this.thresholdField.setDialogFieldListener(validateListener);
        LayoutUtil.doDefaultLayout((Composite)composite, (DialogField[])new DialogField[]{this.thresholdField}, (boolean)true);
        GridLayout layout = (GridLayout)this.thresholdField.getSelectionButtonsGroup(null).getLayout();
        layout.marginLeft = 20;
        if (this.session.getAppender() != null) {
            Level level = this.session.getAppender().getThreshold();
            if (level != null) {
                switch (level.levelInt) {
                    case 10000: {
                        this.thresholdField.setSelection(1, true);
                        break;
                    }
                    case 20000: {
                        this.thresholdField.setSelection(2, true);
                        break;
                    }
                    case 30000: {
                        this.thresholdField.setSelection(3, true);
                        break;
                    }
                    case 40000: {
                        this.thresholdField.setSelection(4, true);
                        break;
                    }
                    default: {
                        this.thresholdField.setSelection(0, true);
                        break;
                    }
                }
            } else {
                this.thresholdField.setSelection(0, true);
            }
        }
    }

    void validate() {
        Appender appender = this.session.getAppender();
        if (appender == null) {
            this.setMessage("Please select an appender type first!");
            return;
        }
        if (this.thresholdField.isSelected(1)) {
            appender.setThreshold(Level.DEBUG);
        } else if (this.thresholdField.isSelected(2)) {
            appender.setThreshold(Level.INFO);
        } else if (this.thresholdField.isSelected(3)) {
            appender.setThreshold(Level.WARN);
        } else if (this.thresholdField.isSelected(4)) {
            appender.setThreshold(Level.ERROR);
        } else {
            appender.setThreshold(null);
        }
        this.setMessage(null);
        this.setPageComplete(true);
    }
}

