/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.admin.ui.p2.internal;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.gyrex.admin.ui.internal.helper.SwtUtil;
import org.eclipse.gyrex.admin.ui.internal.widgets.NonBlockingMessageDialogs;
import org.eclipse.gyrex.admin.ui.p2.internal.EditPackageDialog;
import org.eclipse.gyrex.admin.ui.p2.internal.P2UiLabelProvider;
import org.eclipse.gyrex.admin.ui.pages.AdminPage;
import org.eclipse.gyrex.p2.internal.P2Activator;
import org.eclipse.gyrex.p2.internal.packages.IPackageManager;
import org.eclipse.gyrex.p2.internal.packages.PackageDefinition;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class PackagesSection {
    private final Composite parent;
    private Button addButton;
    private Button removeButton;
    private Button provisionButton;
    private Button revokeButton;
    private ListViewer packagesList;
    private IObservableValue selectedPackageValue;

    @Deprecated
    public PackagesSection(Composite parent, AdminPage page) {
        this.parent = parent;
        this.createContent(this.parent);
    }

    void addButtonPressed() {
        EditPackageDialog dialog = new EditPackageDialog(SwtUtil.getShell((Widget)this.addButton), this.getPackageManager(), null);
        dialog.openNonBlocking(new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    PackagesSection.this.refresh();
                }
            }
        });
    }

    private Button createButton(Composite buttons, String buttonLabel) {
        Button b = new Button(buttons, 0);
        b.setText(buttonLabel);
        b.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return b;
    }

    protected void createButtons(Composite buttonsPanel) {
        this.addButton = this.createButton(buttonsPanel, "Add...");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.addButtonPressed();
            }
        });
        this.removeButton = this.createButton(buttonsPanel, "Remove...");
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.removeButtonPressed();
            }
        });
        this.createButtonsSeparator(buttonsPanel);
        this.provisionButton = this.createButton(buttonsPanel, "Provision");
        this.provisionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.provisionButtonPressed();
            }
        });
        this.revokeButton = this.createButton(buttonsPanel, "Revoke");
        this.revokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 1L;

            public void widgetSelected(SelectionEvent e) {
                PackagesSection.this.revokeButtonPressed();
            }
        });
    }

    private Label createButtonsSeparator(Composite parent) {
        Label separator = new Label(parent, 0);
        separator.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        return separator;
    }

    void createContent(Composite parent) {
        this.packagesList = new ListViewer(parent, 2820);
        List list = this.packagesList.getList();
        list.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.packagesList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.packagesList.setLabelProvider((IBaseLabelProvider)new P2UiLabelProvider());
        this.selectedPackageValue = ViewersObservables.observeSingleSelection((Viewer)this.packagesList);
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(1, 4, false, true));
        buttons.setLayout((Layout)new GridLayout());
        this.createButtons(buttons);
        this.updateButtons();
    }

    protected void createViewer(Composite parent) {
        this.selectedPackageValue = ViewersObservables.observeSingleSelection((Viewer)this.packagesList);
    }

    IPackageManager getPackageManager() {
        return P2Activator.getInstance().getPackageManager();
    }

    private PackageDefinition getSelectedPackage() {
        return (PackageDefinition)(this.selectedPackageValue != null ? this.selectedPackageValue.getValue() : null);
    }

    void provisionButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        this.getPackageManager().markedForInstall(pkg);
        this.updateButtons();
    }

    public void refresh() {
        this.packagesList.setInput((Object)this.getPackageManager().getPackages());
        this.updateButtons();
    }

    void removeButtonPressed() {
        final PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        NonBlockingMessageDialogs.openQuestion((Shell)SwtUtil.getShell((Widget)this.removeButton), (String)"Remove Package", (String)"Do you really want to delete the package?", (DialogCallback)new DialogCallback(){
            private static final long serialVersionUID = 1L;

            public void dialogClosed(int returnCode) {
                if (returnCode == 0) {
                    PackagesSection.this.getPackageManager().removePackage(pkg.getId());
                    PackagesSection.this.refresh();
                }
            }
        });
    }

    void revokeButtonPressed() {
        PackageDefinition pkg = this.getSelectedPackage();
        if (pkg == null) {
            return;
        }
        this.getPackageManager().markedForUninstall(pkg);
        this.updateButtons();
    }

    void updateButtons() {
        if (this.getSelectedPackage() == null) {
            this.removeButton.setEnabled(false);
            this.provisionButton.setEnabled(false);
            this.revokeButton.setEnabled(false);
        } else {
            if (this.getPackageManager().isMarkedForInstall(this.getSelectedPackage())) {
                this.provisionButton.setEnabled(false);
                this.revokeButton.setEnabled(true);
            }
            if (this.getPackageManager().isMarkedForUninstall(this.getSelectedPackage())) {
                this.revokeButton.setEnabled(false);
                this.provisionButton.setEnabled(true);
            }
        }
    }
}

