/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.persistence.internal.storage;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.gyrex.common.identifiers.IdHelper;
import org.eclipse.gyrex.persistence.storage.provider.RepositoryProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepositoryProviderRegistry {
    private final ConcurrentMap<String, RepositoryProviderRegistration> registeredRepositoryTypesById = new ConcurrentHashMap<String, RepositoryProviderRegistration>(5);
    private ServiceTracker<RepositoryProvider, RepositoryProvider> serviceTracker;
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryProviderRegistry.class);

    public void close() {
        this.serviceTracker.close();
        this.serviceTracker = null;
        this.registeredRepositoryTypesById.clear();
    }

    public List<RepositoryProviderRegistration> getAllProviderRegistrations() {
        Collection values = this.registeredRepositoryTypesById.values();
        return Arrays.asList(values.toArray(new RepositoryProviderRegistration[values.size()]));
    }

    public RepositoryProvider getRepositoryProvider(String repositoryProviderId) {
        if (repositoryProviderId == null) {
            throw new IllegalArgumentException("repository type id must not be null");
        }
        RepositoryProviderRegistration registration = (RepositoryProviderRegistration)this.registeredRepositoryTypesById.get(repositoryProviderId);
        if (registration == null) {
            throw new IllegalStateException(MessageFormat.format("repository provider \"{0}\" not available", repositoryProviderId));
        }
        return registration.getProvider();
    }

    public String getRepositoryProviderInfo(String repositoryProviderId) {
        if (repositoryProviderId == null) {
            throw new IllegalArgumentException("repository type id must not be null");
        }
        RepositoryProviderRegistration registration = (RepositoryProviderRegistration)this.registeredRepositoryTypesById.get(repositoryProviderId);
        if (registration == null) {
            throw new IllegalStateException(MessageFormat.format("repository provider \"{0}\" not available", repositoryProviderId));
        }
        return registration.getProviderInfo();
    }

    public void registerRepositoryProvider(String providerId, RepositoryProvider repositoryProvider, String providerInfo) throws IllegalArgumentException, IllegalStateException {
        if (!IdHelper.isValidId((String)providerId)) {
            throw new IllegalArgumentException(String.format("Invalid repository provider id '%s'.", providerId));
        }
        RepositoryProviderRegistration existing = this.registeredRepositoryTypesById.putIfAbsent(providerId, new RepositoryProviderRegistration(repositoryProvider, providerInfo));
        if (existing != null && existing.getProvider() != repositoryProvider) {
            throw new IllegalStateException(String.format("A repository provider with id \"%s\" is already registered!", providerId));
        }
    }

    public void start(BundleContext context) {
        this.serviceTracker = new ServiceTracker<RepositoryProvider, RepositoryProvider>(context, RepositoryProvider.class, null){

            public RepositoryProvider addingService(ServiceReference<RepositoryProvider> reference) {
                RepositoryProvider repositoryProvider = (RepositoryProvider)((Object)super.addingService(reference));
                if (repositoryProvider != null) {
                    try {
                        RepositoryProviderRegistry.this.registerRepositoryProvider(repositoryProvider.getProviderId(), repositoryProvider, (String)reference.getProperty("service.description"));
                    }
                    catch (Exception e) {
                        LOG.error("Unable to register repository provider ({}). {}", new Object[]{reference, ExceptionUtils.getRootCauseMessage((Throwable)e), e});
                    }
                }
                return repositoryProvider;
            }

            public void removedService(ServiceReference<RepositoryProvider> reference, RepositoryProvider service) {
                RepositoryProviderRegistry.this.unregisterRepositoryProvider(service.getProviderId());
                super.removedService(reference, (Object)service);
            }
        };
        this.serviceTracker.open();
    }

    public void unregisterRepositoryProvider(String repositoryProviderId) {
        if (repositoryProviderId == null) {
            throw new IllegalArgumentException("repository type identifier must not be null");
        }
        this.registeredRepositoryTypesById.remove(repositoryProviderId);
    }

    public static class RepositoryProviderRegistration {
        private final RepositoryProvider provider;
        private final String providerInfo;

        public RepositoryProviderRegistration(RepositoryProvider provider, String providerInfo) {
            this.provider = provider;
            this.providerInfo = providerInfo;
        }

        public RepositoryProvider getProvider() {
            return this.provider;
        }

        public String getProviderId() {
            return this.provider.getProviderId();
        }

        public String getProviderInfo() {
            return this.providerInfo;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("RepositoryProviderRegistration [provider=").append((Object)this.provider).append(", providerInfo=").append(this.providerInfo).append("]");
            return builder.toString();
        }
    }
}

