/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gyrex.context.internal.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.gyrex.context.IRuntimeContext;
import org.eclipse.gyrex.context.definitions.ContextDefinition;
import org.eclipse.gyrex.context.definitions.IRuntimeContextDefinitionManager;
import org.eclipse.gyrex.context.internal.ContextActivator;
import org.eclipse.gyrex.context.internal.ContextDebug;
import org.eclipse.gyrex.context.internal.GyrexContextHandle;
import org.eclipse.gyrex.context.internal.GyrexContextImpl;
import org.eclipse.gyrex.context.internal.provider.ObjectProviderRegistry;
import org.eclipse.gyrex.context.registry.IRuntimeContextRegistry;
import org.eclipse.gyrex.preferences.CloudScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextRegistryImpl
implements IRuntimeContextRegistry,
IRuntimeContextDefinitionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ContextRegistryImpl.class);
    private static final Set<String> forbiddenPathSegments;
    private final IEclipsePreferences.IPreferenceChangeListener flushListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!Path.ROOT.isValidPath(event.getKey())) {
                LOG.warn("Ignored attempt to flush hierarcy for invalid path {}.", (Object)event.getKey());
                return;
            }
            try {
                ContextRegistryImpl.this.doFlushHierarchy(ContextRegistryImpl.sanitize((IPath)new Path(event.getKey())));
            }
            catch (Exception e) {
                LOG.error("Error flushing context hierarchy {}: {}", new Object[]{event.getKey(), ExceptionUtils.getRootCauseMessage((Throwable)e), e});
            }
        }
    };
    private final Map<IPath, GyrexContextImpl> contexts;
    private final ConcurrentMap<IPath, GyrexContextHandle> handles;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final ReadWriteLock contextRegistryLock = new ReentrantReadWriteLock();

    static {
        HashSet<String> segments = new HashSet<String>(1);
        segments.add(".settings");
        forbiddenPathSegments = Collections.unmodifiableSet(segments);
    }

    public static IPath sanitize(IPath contextPath) throws IllegalArgumentException {
        if (contextPath == null) {
            throw new IllegalArgumentException("context path must not be null");
        }
        if (contextPath.getDevice() != null) {
            throw new IllegalArgumentException("invalid context path; device id must be null; " + contextPath);
        }
        if (contextPath.isEmpty()) {
            return Path.ROOT;
        }
        String[] stringArray = contextPath.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (forbiddenPathSegments.contains(segment)) {
                throw new IllegalArgumentException(NLS.bind((String)"Segment \"{0}\" not allowed in context path \"{1}\"", (Object)segment, (Object)contextPath));
            }
            ++n2;
        }
        return contextPath.makeAbsolute().addTrailingSeparator();
    }

    public ContextRegistryImpl() {
        this.contexts = new HashMap<IPath, GyrexContextImpl>();
        this.handles = new ConcurrentHashMap<IPath, GyrexContextHandle>();
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed.get()) {
            throw new IllegalStateException("context registry closed");
        }
    }

    public void close() throws Exception {
        GyrexContextImpl[] activeContexts;
        this.closed.set(true);
        this.getContextFlushNode().removePreferenceChangeListener(this.flushListener);
        Lock lock = this.contextRegistryLock.writeLock();
        lock.lock();
        try {
            activeContexts = this.contexts.values().toArray(new GyrexContextImpl[this.contexts.size()]);
            this.contexts.clear();
        }
        finally {
            lock.unlock();
        }
        GyrexContextImpl[] gyrexContextImplArray = activeContexts;
        int n = activeContexts.length;
        int n2 = 0;
        while (n2 < n) {
            GyrexContextImpl context = gyrexContextImplArray[n2];
            context.dispose();
            ++n2;
        }
        this.handles.clear();
    }

    void doFlushHierarchy(IPath contextPath) {
        if (ContextDebug.debug) {
            LOG.debug("Flushing context hierarchy {}...", (Object)contextPath);
        }
        ArrayList<GyrexContextImpl> removedContexts = new ArrayList<GyrexContextImpl>();
        Lock lock = this.contextRegistryLock.writeLock();
        lock.lock();
        try {
            Map.Entry[] entrySet;
            this.checkClosed();
            Map.Entry[] entryArray = entrySet = this.contexts.entrySet().toArray(new Map.Entry[0]);
            int n = entrySet.length;
            int n2 = 0;
            while (n2 < n) {
                GyrexContextImpl contextImpl;
                Map.Entry entry = entryArray[n2];
                IPath entryPath = (IPath)entry.getKey();
                if (contextPath.isPrefixOf(entryPath) && (contextImpl = this.contexts.remove(entryPath)) != null) {
                    removedContexts.add(contextImpl);
                }
                ++n2;
            }
        }
        finally {
            lock.unlock();
        }
        for (GyrexContextImpl contextImpl : removedContexts) {
            if (ContextDebug.debug) {
                LOG.debug("Disposing context {}...", (Object)contextImpl);
            }
            contextImpl.dispose();
        }
        LOG.info("Flushed context hierarchy {}.", (Object)contextPath);
    }

    public void flushContextHierarchy(IPath contextPath) throws Exception {
        this.checkClosed();
        if (ContextDebug.debug) {
            LOG.debug("Sending flush event for context hierarchy {} to all nodes in the cloud...", (Object)contextPath);
        }
        IEclipsePreferences node = this.getContextFlushNode();
        node.sync();
        String key = ContextRegistryImpl.sanitize(contextPath).toString();
        node.putLong(key, node.getLong(key, 0L) + 1L);
        this.getContextFlushNode().flush();
        LOG.debug("Flush event for context hierarchy {} sent to all nodes in the cloud ({} flush events so far).", (Object)contextPath, (Object)node.getLong(key, 0L));
    }

    @Deprecated
    public void flushContextHierarchy(IRuntimeContext context) {
        this.checkClosed();
        this.doFlushHierarchy(context.getContextPath());
    }

    @Override
    public GyrexContextHandle get(IPath contextPath) throws IllegalArgumentException {
        return this.getHandle(contextPath);
    }

    private Preferences getContextDefinitionStore() {
        return CloudScope.INSTANCE.getNode("org.eclipse.gyrex.context").node("definedContexts");
    }

    private IEclipsePreferences getContextFlushNode() {
        return (IEclipsePreferences)CloudScope.INSTANCE.getNode("org.eclipse.gyrex.context").node("contextFlushes");
    }

    @Override
    public List<ContextDefinition> getDefinedContexts() {
        this.checkClosed();
        try {
            Preferences node = this.getContextDefinitionStore();
            String[] keys = node.keys();
            ArrayList<ContextDefinition> contexts = new ArrayList<ContextDefinition>(keys.length + 1);
            contexts.add(this.getRootDefinition());
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                ContextDefinition definition = new ContextDefinition((IPath)new Path(path));
                definition.setName(node.get(path, null));
                contexts.add(definition);
                ++n2;
            }
            return Collections.unmodifiableList(contexts);
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error reading context definitions. %s", ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public ContextDefinition getDefinition(IPath contextPath) {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        if (contextPath.isRoot()) {
            return this.getRootDefinition();
        }
        Preferences node = this.getContextDefinitionStore();
        String name = node.get(contextPath.toString(), null);
        if (name == null) {
            return null;
        }
        ContextDefinition definition = new ContextDefinition(contextPath);
        definition.setName(name);
        return definition;
    }

    public GyrexContextHandle getHandle(IPath contextPath) {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        GyrexContextHandle contextHandle = (GyrexContextHandle)this.handles.get(contextPath);
        while (contextHandle == null) {
            ContextDefinition definition = this.getDefinition(contextPath);
            if (definition == null) {
                return null;
            }
            contextHandle = this.handles.putIfAbsent(contextPath, new GyrexContextHandle(contextPath, this));
            if (contextHandle != null) continue;
            contextHandle = (GyrexContextHandle)this.handles.get(contextPath);
        }
        return contextHandle;
    }

    public ObjectProviderRegistry getObjectProviderRegistry() {
        return ContextActivator.getInstance().getObjectProviderRegistry();
    }

    public GyrexContextImpl getRealContext(IPath contextPath) throws IllegalArgumentException {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        GyrexContextImpl context = null;
        Lock readLock = this.contextRegistryLock.readLock();
        readLock.lock();
        try {
            context = this.contexts.get(contextPath);
            if (context != null) {
                GyrexContextImpl gyrexContextImpl = context;
                return gyrexContextImpl;
            }
        }
        finally {
            readLock.unlock();
        }
        this.getContextFlushNode().addPreferenceChangeListener(this.flushListener);
        Lock lock = this.contextRegistryLock.writeLock();
        lock.lock();
        try {
            this.checkClosed();
            context = this.contexts.get(contextPath);
            if (context != null) {
                GyrexContextImpl gyrexContextImpl = context;
                return gyrexContextImpl;
            }
            ContextDefinition definition = this.getDefinition(contextPath);
            if (definition == null) {
                throw new IllegalStateException(String.format("Context '%s' does not exists.", contextPath.toString()));
            }
            context = new GyrexContextImpl(contextPath, this);
            if (this.contexts.put(contextPath, context) != null) {
                throw new IllegalStateException(String.format("Duplicate context object created for context '%s'. Please report stacktrace to the development team!", contextPath.toString()));
            }
        }
        finally {
            lock.unlock();
        }
        return context;
    }

    private ContextDefinition getRootDefinition() {
        ContextDefinition rootDefinition = new ContextDefinition((IPath)Path.ROOT);
        rootDefinition.setName("ROOT (/)");
        return rootDefinition;
    }

    public boolean hasRealContext(IPath contextPath) throws IllegalArgumentException {
        this.checkClosed();
        contextPath = ContextRegistryImpl.sanitize(contextPath);
        Lock readLock = this.contextRegistryLock.readLock();
        readLock.lock();
        try {
            boolean bl = this.contexts.containsKey(contextPath);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public void removeDefinition(ContextDefinition contextDefinition) {
        this.checkClosed();
        try {
            this.removeDefinition(contextDefinition.getPath());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    @Override
    public void removeDefinition(IPath contextPath) throws Exception {
        this.checkClosed();
        IPath path = ContextRegistryImpl.sanitize(contextPath);
        if (path.isRoot()) {
            throw new IllegalArgumentException("cannot remove root context");
        }
        try {
            Preferences node = this.getContextDefinitionStore();
            node.sync();
            node.remove(path.toString());
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error removing context definition %s. %s", path, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }

    @Override
    public void saveDefinition(ContextDefinition contextDefinition) {
        this.checkClosed();
        IPath path = ContextRegistryImpl.sanitize(contextDefinition.getPath());
        if (path.isRoot()) {
            throw new IllegalArgumentException("cannot modify root context");
        }
        try {
            Preferences node = this.getContextDefinitionStore();
            String name = contextDefinition.getName();
            node.put(path.toString(), StringUtils.isNotBlank((String)name) ? name : "");
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException(String.format("Error saving context definition %s. %s", path, ExceptionUtils.getRootCauseMessage((Throwable)e)), e);
        }
    }
}

